#include "main.h"

/* LCD */
LCD_DISCO_F746NG lcd;

/* TS */
TS_DISCO_F746NG ts;

/* Serial */
Serial pc(USBTX,USBRX);
Serial robot(PC_6,PC_7,115200); // D1,D0 Serial 6

/* Variables */
uint16_t x = 0, y = 0;
bool port_depart = BLEU;
bool match_started = false;
bool robot_init = true;
uint8_t menu_select = MENU1;

int main()
{
    pc.printf("ARES21_IHM\r\n");

    TS_StateTypeDef TS_State;
    ts.Init(LARGEUR_LCD, HAUTEUR_LCD);

    lcd.Clear(LCD_COLOR_BLACK);
    lcd.SetBackColor(LCD_COLOR_BLACK);
    lcd.SetTextColor(LCD_COLOR_WHITE);

    lcd.SetFont(&Font24);
    lcd.DisplayStringAt(0,  100, (uint8_t *)"Ares ENSEA", CENTER_MODE);
    lcd.SetFont(&Font12);
    lcd.DisplayStringAt(0,  150, (uint8_t *)"Coupe de France de robotique 2021", CENTER_MODE);
    lcd.SetFont(&Font12);
    lcd.DisplayStringAt(0,  200, (uint8_t *)"Robot en cours d'initialisation...", CENTER_MODE);

    wait(3);
    aff_preparation(port_depart);

    while(1) {


        ts.GetState(&TS_State);
        if (TS_State.touchDetected) {
            x = TS_State.touchX[0];
            y = TS_State.touchY[0];
            pc.printf("touchX = %d, touchY = %d\r\n",x,y);

            switch(menu_select) {
                case MENU1 :
                    if (x >= 25 && x <= 225 && y >= 68 && y <= 194) {
                        wait_unpressed(TS_State);
                        port_depart = !port_depart;
                        if (port_depart == JAUNE) robot.printf("J\n");
                        else  robot.printf("B\n");

                        aff_preparation(port_depart);
                    } else if(x >= 255 && x <= 455 && y >= 68 && y <= 194) {
                        wait_unpressed(TS_State);
                        menu_select = MENU2;
                        aff_score();
                    } else if(x >= 145 && x <= 345 && y >= 212 && y <= 262) {
                        if(match_started == 0) {
                            wait_unpressed(TS_State);
                            menu_select = MENU1;
                            robot.printf("M\n");
                            match_started = true;
                            aff_preparation(port_depart);
                        }
                    }
                    break;

                case MENU2 :
                    if(x >= 420 && x <= 470 && y >= 10 && y <= 60) {
                        wait_unpressed(TS_State);
                        menu_select = MENU1;
                        aff_preparation(port_depart);
                    } else {
                        lcd.SetTextColor(LCD_COLOR_WHITE);
                        lcd.FillCircle(x, y, 10);
                    }

                    break;

                case MENU3 :
                    if(x >= 255 && x <= 455 && y >= 212 && y <= 262) {
                        wait_unpressed(TS_State);
                        menu_select = MENU1;
                        aff_preparation(port_depart);
                    }
                    break;

                default :
                    break;
            }
        }
    }
}

int decodeMsgRobot(char *buffer)
{
    switch(buffer[0]) {
        case 'I' :
            robot_init = true;
            aff_preparation(port_depart);
            break;
        default :
            break;
    }

    return 0;
}

void wait_unpressed(TS_StateTypeDef TS_State)
{
    do {
        ts.GetState(&TS_State);
    } while(TS_State.touchDetected);
}

void aff_preparation(bool port_depart)
{
    lcd.Clear(LCD_COLOR_BLACK);
    lcd.SetBackColor(LCD_COLOR_BLACK);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.SetFont(&Font24);
    lcd.DisplayStringAt(0, 20, (uint8_t *)"Preparation d'avant match", CENTER_MODE);

    if (port_depart == JAUNE) lcd.SetTextColor(LCD_COLOR_YELLOW);
    else lcd.SetTextColor(LCD_COLOR_BLUE);
    lcd.FillRect(25, 68, 200, 126);

    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.FillRect(255, 68, 200, 126);
    lcd.SetBackColor(LCD_COLOR_WHITE);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.DisplayStringAt(312, 125, (uint8_t *)"Score", LEFT_MODE);

    if (match_started == 0) {
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.FillRect(145, 212, 200, 50);
        lcd.SetBackColor(LCD_COLOR_WHITE);
        lcd.SetTextColor(LCD_COLOR_BLACK);
        lcd.DisplayStringAt(170, 229, (uint8_t *)"(Tirette)", LEFT_MODE);
    }
}

void aff_score()
{
    lcd.Clear(LCD_COLOR_BLACK);

    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.FillCircle(445, 35, 25);

    lcd.SetBackColor(LCD_COLOR_WHITE);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.SetFont(&Font12);
    lcd.DisplayStringAt(425, 30, (uint8_t *)"Retour", LEFT_MODE);
}

void aff_tests()
{
    lcd.Clear(LCD_COLOR_BLACK);

    lcd.SetBackColor(LCD_COLOR_BLACK);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.SetFont(&Font24);
    lcd.DisplayStringAt(0, 20, (uint8_t *)"Preparation d'avant match", CENTER_MODE);

    lcd.SetBackColor(LCD_COLOR_WHITE);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.FillRect(255, 212, 200, 50);

    lcd.SetBackColor(LCD_COLOR_WHITE);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.SetFont(&Font24);
    lcd.DisplayStringAt(305, 229, (uint8_t *)"Retour", LEFT_MODE);
}
