#include "uOLED.h"
#include "mbed.h"


#define     OLED_INITDELAYMS            1200

#define     OLED_ACK                    0x06  // Ok
#define     OLED_NAK                    0x15  // Error
//uOLED *pSGC;



uOLED::uOLED(PinName serialTX, PinName serialRX, PinName reset) :
    _oled(serialTX, serialRX),
    _reset(reset) {

    _oled.baud(230400);
    
    //friend class uOLED_watch;
}

/******************/
/* Protected      */
/******************/
void uOLED::resetDisplay() {
    _reset = 0;
    wait_ms(20);
    _reset = 1;
    wait_ms(20);
}




/******************/
/* Public         */
/******************/
short uOLED::getRGB(char red, char green, char blue) {
    int outR = ((red * 31) / 255);
    int outG = ((green * 63) / 255);
    int outB = ((blue * 31) / 255);
    
    return (outR << 11) | (outG << 5) | outB;
}

bool uOLED::addBitmappedCharacter(char character, char data[8]) {
    _oled.putc(0x41);
    _oled.putc(character);
    for (int i=0; i<8; i++) _oled.putc(data[i]);
    return (_oled.getc() == OLED_ACK);
}

bool uOLED::blockCopyPaste(char sourceX, char sourceY, char destinationX, char destinationY, char width, char height) {
    _oled.putc(0x63);
    _oled.putc(sourceX);
    _oled.putc(sourceY);
    _oled.putc(destinationX);
    _oled.putc(destinationY);
    _oled.putc(width);
    _oled.putc(height);

    return (_oled.getc() == OLED_ACK);
}

bool uOLED::screenCopy(char x, char y, char width, char height, char sectorHi, char sectorMid, char sectorLow)
{
    _oled.putc(0x40);
    _oled.putc(0x43);
    _oled.putc(x);
    _oled.putc(y);
    _oled.putc(width);
    _oled.putc(height);
    _oled.putc(sectorHi);
    _oled.putc(sectorMid);
    _oled.putc(sectorLow);

    return (_oled.getc() == OLED_ACK);
}

bool uOLED::displayControl(char mode, char value) {
    _oled.putc(0x59);
    _oled.putc(mode);
    _oled.putc(value);
    
    return (_oled.getc() == OLED_ACK);
}

bool uOLED::displayUserBitmappedCharacter(char character, char x, char y, short red, short green, short blue)
{
    short colour = getRGB(red, green, blue);

    _oled.putc(0x44);  
    _oled.putc(character);
    _oled.putc(x);
    _oled.putc(y);
    _oled.putc(colour >> 8);
    _oled.putc(colour & 0xFF);
    
    return (_oled.getc() == OLED_ACK);
}

bool uOLED::drawCharacter(char character, char column, char row, short red, short green, short blue)
{
    short colour = getRGB(red, green, blue);

    _oled.putc(0x54);
    _oled.putc(character);
    _oled.putc(column);
    _oled.putc(row);    
    _oled.putc(colour >> 8);
    _oled.putc(colour & 0xFF);
    
    return (_oled.getc() == OLED_ACK);
}

bool uOLED::drawCircle(char x, char y, char radius, short red, short green, short blue)
{
    short color = getRGB(red, green, blue);
    
    _oled.putc(0x43);     
    _oled.putc(x);
    _oled.putc(y);
    _oled.putc(radius);
    _oled.putc(color >> 8);
    _oled.putc(color & 0xFF);
    
    return (_oled.getc() == OLED_ACK);
}

bool uOLED::drawImage(char x, char y, char width, char height, char colorMode, char *pixels) {
    int numberOfBytesPerPixel = 1;
    
    _oled.putc(0x49);
    _oled.putc(x);
    _oled.putc(y);
    _oled.putc(width);
    _oled.putc(height);
    _oled.putc(colorMode);
    
    if (colorMode == 16) numberOfBytesPerPixel = 2;
        
    for (int i=0; i<width * height * numberOfBytesPerPixel; i++) {
        _oled.putc(pixels[i]);
    }

    return (_oled.getc() == OLED_ACK);
}

bool uOLED::drawImageSD_16bit(char x, char y, char width, char height, char colourMode, char sectorHi, char sectorMid, char sectorLow)
{
   
    _oled.putc(0x40);
    _oled.putc(0x49);
    _oled.putc(x);
    _oled.putc(y);
    _oled.putc(width);
    _oled.putc(height);
    _oled.putc(colourMode);
    _oled.putc(sectorHi);
    _oled.putc(sectorMid);
    _oled.putc(sectorLow);
    
    return (_oled.getc() == OLED_ACK);
}

bool uOLED::drawLine(char x1, char y1, char x2, char y2, short red, short green, short blue)
{
    short color = getRGB(red, green, blue);
    
    _oled.putc(0x4C);
    _oled.putc(x1);
    _oled.putc(y1);
    _oled.putc(x2);
    _oled.putc(y2);
    _oled.putc(color >> 8);
    _oled.putc(color & 0xFF);
    
    return (_oled.getc() == OLED_ACK);
}

bool uOLED::drawPolygon(char vertices, char *x, char *y, short red, short green, short blue) {
    short colour = getRGB(red, green, blue);
    
    _oled.putc(0x67);
    _oled.putc(vertices);
    for (int i=0; i < vertices; i++) {
        _oled.putc(x[i]);
        _oled.putc(y[i]);
    }
    _oled.putc(colour >> 8);
    _oled.putc(colour & 0xFF);
    
    return (_oled.getc() == OLED_ACK);
}

bool uOLED::drawRectangle(char x, char y, char width, char height, short red, short green, short blue)
{
    short colour = getRGB(red, green, blue);
    
    _oled.putc(0x72);
    _oled.putc(x);
    _oled.putc(y);   
    _oled.putc(x + width);
    _oled.putc(y + height);
    _oled.putc(colour >> 8);
    _oled.putc(colour & 0xFF);

    return (_oled.getc() == OLED_ACK);
}

bool uOLED::drawText(char column, char row, char font, short red, short green, short blue, char *text)
{

    short colour = getRGB(red, green, blue);

    _oled.putc(0x73);
    _oled.putc(column);
    _oled.putc(row);
    _oled.putc(font);   
    _oled.putc(colour >> 8);
    _oled.putc(colour & 0xFF);  
    for (int i=0 ; i<strlen(text) ; i++) _oled.putc(text[i]);
    _oled.putc(0x00);
    
    return (_oled.getc() == OLED_ACK);
}

bool uOLED::drawTextUF(char x, char y, char font, short red, short green, short blue, char width, char height, char *text) {
    
    short colour = getRGB(red, green, blue);
    
    _oled.putc(0x53);
    _oled.putc(x);
    _oled.putc(y);
    _oled.putc(font);   
    _oled.putc(colour >> 8);
    _oled.putc(colour & 0xFF);  
    _oled.putc(width);
    _oled.putc(height);
    for (int i=0 ; i<strlen(text) ; i++) _oled.putc(text[i]);
    _oled.putc(0x00);
    
    return (_oled.getc() == OLED_ACK);
}

bool uOLED::drawTriangle(char x1, char y1, char x2, char y2, char x3, char y3, short red, short green, short blue)
{

    short colour = getRGB(red, green, blue);
    
    _oled.putc(0x47);
    _oled.putc(x1);
    _oled.putc(y1);
    _oled.putc(x2);
    _oled.putc(y2);
    _oled.putc(x3);
    _oled.putc(y3);
    _oled.putc(colour >> 8);
    _oled.putc(colour & 0xFF);

    return (_oled.getc() == OLED_ACK);
}

bool uOLED::eraseScreen() {
    _oled.putc(0x45);

    return (_oled.getc() == OLED_ACK);
}

bool uOLED::init() {
    resetDisplay();  
    
    wait_ms(OLED_INITDELAYMS); 
    _oled.putc(0x55);
    
    _oled.getc();
    
    _oled.putc(0x4F);
    _oled.putc(0x01);

    return (_oled.getc() == OLED_ACK);
}

bool uOLED::penSize(char size) {
    _oled.putc(0x70);
    _oled.putc(size);
    
    return (_oled.getc() == OLED_ACK);
}

bool uOLED::putPixel(char x, char y, short red, short green, short blue)
{
    short colour = getRGB(red, green, blue);

    _oled.putc(0x50);
    _oled.putc(x);
    _oled.putc(y);
    
    _oled.putc(colour >> 8);
    _oled.putc(colour & 0xFF);
    
    return (_oled.getc() == OLED_ACK);
}

short uOLED::readPixel(char x, char y) {
    short returnValue;
    
    _oled.putc(0x52);
    _oled.putc(x);
    _oled.putc(y);
    returnValue = (_oled.getc() << 8);
    returnValue += _oled.getc();
    
    return returnValue;
}

bool uOLED::setBackgroundColour(char red, char green, char blue)
{
    short colour = getRGB(red, green, blue);

    _oled.putc(0x42);
    
    _oled.putc(colour >> 8);
    _oled.putc(colour & 0xFF);

    return (_oled.getc() == OLED_ACK);
}

bool uOLED::setFont(char font) {
    _oled.putc(0x46);
    _oled.putc(font);
    
    return (_oled.getc() == OLED_ACK);
}

bool uOLED::textButton(char state, char x, char y, short red, short green, short blue, char font, short textRed, short textGreen, short textBlue, char textWidth, char textHeight, char *text)
{
    short buttonColour = getRGB(red, green, blue);
    short textColour = getRGB(textRed, textGreen, textBlue);

    _oled.putc(0x62);
    _oled.putc(state);
    _oled.putc(x);
    _oled.putc(y);
    _oled.putc(buttonColour >> 8);
    _oled.putc(buttonColour & 0xFF);
    _oled.putc(font);
    _oled.putc(textColour >> 8);
    _oled.putc(textColour & 0xFF);
    _oled.putc(textWidth);
    _oled.putc(textHeight);
    for (int i=0 ; i<strlen(text) ; i++) _oled.putc(text[i]);   
    _oled.putc(0x00);
    
    return (_oled.getc() == OLED_ACK);
}

bool uOLED::textMode(char mode) {
    _oled.putc(0x4F);
    _oled.putc(mode);
    
    return (_oled.getc() == OLED_ACK);
}

bool uOLED::versionInfo(bool onScreen, char info[5]) {
    _oled.putc(0x56);
    if (onScreen) {
        _oled.putc(0x01);
    } else {
        _oled.putc(0x00);
    }
    
    info[0] = _oled.getc();
    info[1] = _oled.getc();
    info[2] = _oled.getc();
    info[3] = _oled.getc();
    info[4] = _oled.getc();
    
    return true;    
}