#include "mbed.h"

#define TRACK_INC  0.02

DigitalIn buttonPin(p8);
DigitalIn rightPin(p15);
DigitalIn leftPin(p16);
DigitalIn downPin(p17);
DigitalIn upPin(p18);

PwmOut blueLED(p23);
PwmOut redLED(p24);
PwmOut greenLED(p25);
PwmOut whiteLED(p26);

Timer outputTimer;
Serial PC(USBTX, USBRX);


int buttonPushCounter = 0;   // counter for the number of button presses

char buttonState = 0;         // current state of the button
char lastButtonState = 0;     // previous state of the button

char upState = 0;
char downState = 0;
char leftState = 0;
char rightState = 0;
char lastUpState = 0;
char lastDownState = 0;
char lastLeftState = 0;
char lastRightState = 0;

float xPosition = 0.0;
float yPosition = 0.0;



void setup() 
{
    PC.baud(230400);

    buttonPin.mode(PullUp);

    redLED = 0.0;
    greenLED = 0.0;
    blueLED = 0.0;
    whiteLED = 0.0;

    outputTimer.start();
}


int main() 
{
    setup();

    while (1) 
    {

        buttonState = buttonPin.read();

        // compare the buttonState to its previous state
        if (buttonState != lastButtonState) 
        {
            // if the state has changed, increment the counter
            if (buttonState == 1) 
            {
                // if the current state is 1 then the button
                // went from off to on:
                buttonPushCounter++;
                printf("Number of button pushes:  %i\n", buttonPushCounter);
            }
        }
        lastButtonState = buttonState;


        if (buttonPushCounter % 2 == 0) 
        {
            redLED = 1;
        }
        else 
        {
            redLED = 0;
        }

        upState = upPin.read();

        if (upState != lastUpState) 
        {
            if (upState == 1) 
            {
                // if the current state is 1 then the button
                // went from off to on:
                yPosition+=TRACK_INC;
                if (yPosition > 1.0) 
                {
                    yPosition = 1.0;
                }
            }
        }
        lastUpState = upState;


        downState = downPin.read();

        // compare the buttonState to its previous state
        if (downState != lastDownState)
        {
            // if the state has changed, increment the counter
            if (downState == 1) 
            {
                // if the current state is 1 then the button
                // went from off to on:
                yPosition-=TRACK_INC;
                if (yPosition < 0.0) 
                {
                    yPosition = 0.0;
                }
            }
        }
        lastDownState = downState;


        leftState = leftPin.read();

        // compare the buttonState to its previous state
        if (leftState != lastLeftState) 
        {
            // if the state has changed, increment the counter
            if (leftState == 1) 
            {
                // if the current state is 1 then the button
                // went from off to on:
                xPosition-=TRACK_INC;
                if (xPosition < 0.0) 
                {
                    xPosition = 0.0;
                }
            }
        }
        lastLeftState = leftState;

        rightState = rightPin.read();

        // compare the buttonState to its previous state
        if (rightState != lastRightState) 
        {
            // if the state has changed, increment the counter
            if (rightState == 1) 
            {
                // if the current state is 1 then the button
                // went from off to on:
                xPosition+=TRACK_INC;
                if (xPosition > 1.0) 
                {
                    xPosition = 1.0;
                }
            }
        }
        lastRightState = rightState;

        blueLED = xPosition;
        greenLED = yPosition;



        if (outputTimer.read_ms() > 1000) 
        {
            printf("Position:  (x%f, y%f)\n", xPosition, yPosition);

            outputTimer.reset();

        }
    }
}