#include "mbed.h"
#include "trackballer.h"




trackballer::trackballer(PinName button, PinName right, PinName down, PinName left, PinName up, PinName red, PinName green, PinName blue, PinName white, char limits)
{
    
    _limits = limits;
    
    _buttonPin = new DigitalIn(button);
    _rightPin = new DigitalIn(right);
    _downPin = new DigitalIn(down);
    _leftPin = new DigitalIn(left);
    _upPin = new DigitalIn(up);
    
    _redLED = new PwmOut(red);
    _greenLED = new PwmOut(green);
    _blueLED = new PwmOut(blue);
    _whiteLED = new PwmOut(white);



    _buttonPushCounter = 0;   // counter for the number of button presses
    
    _buttonState = 1;         // current state of the button
    _lastButtonState = 1;     // previous state of the button
    
    _upState = 0;
    _downState = 0;
    _leftState = 0;
    _rightState = 0;
    _lastUpState = 0;
    _lastDownState = 0;
    _lastLeftState = 0;
    _lastRightState = 0;
    
    _xPosition = 0.5;
    _yPosition = 0.5;
    
    
    _buttonPin->mode(PullUp);

    _redLED->write(0.0);
    _greenLED->write(0.0);
    _blueLED->write(0.0);
    _whiteLED->write(0.0);
 
    _direction = 0x00;

    _outputTimer.start();

}



/******************/
/* Public         */
/******************/


void trackballer::getState(float &xPosition, float &yPosition, char &button)
{
    char heldState = 0x00;
    char isHeld = 0x00;
    char exitWhile = 0x00;

    _buttonState = _buttonPin->read();

    //int counter1 = 0;

    // compare the _buttonState to its previous state
    if (_buttonState != _lastButtonState) 
    {
        
        // if the state has changed, increment the counter
        if (_buttonState == 1) 
        {
            
            
            /*
            while(_buttonPin->read() == _buttonState)
            {
                //printf("HELD\n");
                counter1++;
                if(counter1 > 20)
                {
                    printf("HELD\n");
                    return;
                }
            }
            */
            // if the current state is 1 then the button
            // went from off to on:
            _buttonPushCounter++;
            button = 0x01;
            //printf("Number of button pushes:  %i\n", _buttonPushCounter);
        }
        else if(_buttonState == 0)
        {
            _holdTimer.start();
            while(_holdTimer.read() < 2.0  && !exitWhile)
            {
                heldState = !_buttonPin->read();
                
                if(heldState == 0)
                {
                    isHeld = 0x00;
                    exitWhile = 0x01;
                }
                else
                {
                    if(_holdTimer.read() > 1.0)
                    {
                        isHeld = 0x01;
                        exitWhile = 0x01;
                    }
                }
                
                
            }
            
            _holdTimer.stop();
            _holdTimer.reset();
            
            if(isHeld)
            {
                printf("HELD\n");
                button = 0x03;
                return;
            }
        }
    }
    else
    {
        button = 0x00;
    }
    _lastButtonState = _buttonState;
    //button = !_buttonState;


    if (_buttonPushCounter % 2 == 0) 
    {
        _redLED->write(1);
        //button = 0x01;
    }
    else 
    {
        _redLED->write(0);
        //button = 0x00;
    }

    _upState = _upPin->read();

    if (_upState != _lastUpState) 
    {
        if (_upState == 1) 
        {
            // if the current state is 1 then the button
            // went from off to on:
            _yPosition-=TRACK_INC;
            if(_limits)
            {
                if (_yPosition < 0.0) 
                {
                    _yPosition = 0.0;
                }
            }
        }
    }
    _lastUpState = _upState;


    _downState = _downPin->read();

    // compare the _buttonState to its previous state
    if (_downState != _lastDownState)
    {
        // if the state has changed, increment the counter
        if (_downState == 1) 
        {
            // if the current state is 1 then the button
            // went from off to on:
            _yPosition+=TRACK_INC;
            if(_limits)
            {
                if (_yPosition > 1.0) 
                {
                    _yPosition = 1.0;
                }
            }
        }
    }
    _lastDownState = _downState;


    _leftState = _leftPin->read();

    // compare the _buttonState to its previous state
    if (_leftState != _lastLeftState) 
    {
        // if the state has changed, increment the counter
        if (_leftState == 1) 
        {
            // if the current state is 1 then the button
            // went from off to on:
            _xPosition-=TRACK_INC;
            if(_limits)
            {
                if (_xPosition < 0.0) 
                {
                    _xPosition = 0.0;
                }
            }
        }
    }
    _lastLeftState = _leftState;

    _rightState = _rightPin->read();

    // compare the _buttonState to its previous state
    if (_rightState != _lastRightState) 
    {
        // if the state has changed, increment the counter
        if (_rightState == 1) 
        {
            // if the current state is 1 then the button
            // went from off to on:
            _xPosition+=TRACK_INC;
            if(_limits)
            {
                if (_xPosition > 1.0) 
                {
                    _xPosition = 1.0;
                }
            }
        }
    }
    _lastRightState = _rightState;

    _blueLED->write(_xPosition);
    _greenLED->write(_yPosition);
    
    xPosition = _xPosition;
    yPosition = _yPosition;



    #if DEBUG_POSITION
    int ixPosition = _xPosition * 95;
    int iyPosition = _yPosition * 63;
    
    
    
    if (_outputTimer.read_ms() > 1000) 
    {
        printf("Position:  (x%i, y%i)\n", ixPosition, iyPosition);

        _outputTimer.reset();

    }
    #endif

}

void trackballer::reset()
{
    _xPosition = 0.5;
    _yPosition = 0.5;
}