/* This library is for Sparkfun Entertainment's Trackballer breakout board.
 * The board consists (mainly) of the trackball, 4 hall effect sensors, some magnets (obviously),
 * a button, and 4 leds (white, red, green, blue).
 *
 * This library (trackballer) by Aaron Goselin.
 * 2010 Aaron Goselin.
 *
 * You are free to use this as you like, but I would prefer credits stay in tact.
 *
 */

#ifndef _TRACKBALLER_
#define _TRACKBALLER_

#include "mbed.h"
//#include "PinDetect_m.h"

#define TRACK_INC 0.01

#define DEBUG_POSITION 0



class trackballer {

public:

    


    trackballer(PinName button, PinName right, PinName down, PinName left, PinName up, PinName red, PinName green, PinName blue, PinName white, char limits = 0x00);
    
    void getState(float &xPosition, float &yPosition, char &button);
    void reset();
    
    
    
        
protected:
    Timer _outputTimer;
    Timer _holdTimer;
    
    DigitalIn * _buttonPin;
    DigitalIn * _rightPin;
    DigitalIn * _downPin;
    DigitalIn * _leftPin;
    DigitalIn * _upPin;
    
    PwmOut * _redLED;
    PwmOut * _greenLED;
    PwmOut * _blueLED;
    PwmOut * _whiteLED;
    
    int _buttonPushCounter;   // counter for the number of button presses

    char _buttonState;         // current state of the button
    char _lastButtonState;     // previous state of the button
    
    char _upState;
    char _downState;
    char _leftState;
    char _rightState;
    char _lastUpState;
    char _lastDownState;
    char _lastLeftState;
    char _lastRightState;
    
    float _xPosition;
    float _yPosition;
    
    
    char _direction;
    char _limits;
  

};

#endif