#include "mbed.h"
#include "theBadTouch.h"


theBadTouch::theBadTouch(PinName touchPin, PinName sink)
{
    _sensor = touchPin;
    //_sink = sink;
    _sink = new DigitalIn(sink);
    _sink->mode(PullUp);
    tracker1 = false;
    tracker2 = false;
    _touchFlag = 0x00;
    falseCounter = 0;
    t.start();
    t_off.start();
    _touchCounter = 0x00;
}



/******************/
/* Protected      */
/******************/




/******************/
/* Public         */
/******************/
// _touchFlag
// 0x00 = Free (untouched long enough to be available for instant touch)
// 0x01 = being touched
// 0x02 = Timing length of time sensor is untouched

char theBadTouch::isTouch()
{
    if(falseCounter > 5)
    {
        _untouchedFlag = 0x01;
        falseCounter = 0;
        return 0x00;
    }
    
    
    

    if(badPlace() >= 0.8)
    {
    /*
        if(_touchCounter < 0x03)
        {
            _touchCounter++;
            return false;
        }
        else
        {
            _touchCounter = 0x00;
        }
      */  
        if(_untouchedFlag == 0x01)
        {
            _untouchedFlag = 0x00;
            return 0x01;
        }
        else
        {
            t.reset();
            for(int i = 0; i < 20; i++)
            {
                //while(badPlace() >= 0.8)
                //{
                if(badPlace() >= 0.8)
                {
                    if(t.read_ms() > 200)
                    {
                        return 0x02;
                    }
                }
                //}
            }
        }
    }
    else
    {
        falseCounter++;
        return 0x00;
    }
    
    return 0x00;
}

float theBadTouch::badPlace()
{
    _precharge = new DigitalInOut(_sensor);
    _precharge->output();
    (*_precharge) = 1; 
    _precharge->input();
    _precharge->mode(PullNone);
    delete _precharge;
    wait_ms(10);
    _sense = new AnalogIn(_sensor);
    float value = *_sense;
    delete _sense;
    
    printf("Value:  %f\n", value);
    wait(.5);
    return value;
}