#include "player.h"

#define PLAYER_XP_PER_LEVEL 5


// Comparison template function.
// I didn't end up using it in this code
// but if you want to give differing amounts of
// xp depending on player and enemy levels this
// could prove useful (although you will likely
// want to customize it).
template <class T>
T getMax(T a, T b) 
{
  T result;
  result = (a > b) ? a : b;
  return (result);
}

// Constructor
player::player()
{
    _level = 0x01;
    
    _baseHealth = 300;
    
    _health = _level * _baseHealth;
    
    _experience = 0;
    
    #if DEBUG_PLAYER
    printf("Creating player character.\n");
    #endif
    
}


// Return the player's experience point count
unsigned long int player::getExperience()
{
    return _experience;
}

// Check experience with required experience
// and level up if needed/possible
void player::isLevelUp()
{   
    unsigned long int xpToLevel = ( (PLAYER_XP_PER_LEVEL * _level) * (PLAYER_XP_PER_LEVEL * _level) + 360);
    
    if(_experience >= xpToLevel)
    {
        if(_level <= 0xFF)
        {
            _level++;
            printf("LEVEL UP!\nYou are now level %i\n", _level);
            xpToLevel = ( (PLAYER_XP_PER_LEVEL * _level) * (PLAYER_XP_PER_LEVEL * _level) + 360);
            printf("Current XP is (%ul / %ul)\n", _experience, xpToLevel);
            _health = (_level * _baseHealth) - _health;
        }
    }
    else if(_experience >= xpToLevel)
    {
        printf("Level cap reached!\n");
    }
    else
    {
        printf("Current XP is (%ul / %ul)\n", _experience, xpToLevel);
    }
    
    wait(1);
}

// Add experience points
// You would likely want to update this
// to give more or less xp depending on 
// player and enemy levels.
void player::addExperience()
{   
    int xp;
    
    if(_level < 0x09)
    {
        xp = (_level * PLAYER_XP_PER_LEVEL) + 45;
    }
    else
    {
        xp = (_level * PLAYER_XP_PER_LEVEL) + 90;
    }
    
    _experience = _experience + xp;
    
    printf("A winner is you!  You have gained %i XP\n", xp);
    
    srand ( time(NULL) );
    int healthGain = (_baseHealth - ( rand() % _baseHealth ) ) / 3;
    
    if(_health + healthGain > (_level * _baseHealth) ) 
    {
        _health = (_level * _baseHealth);
        printf("You have a chance to rest between fights.  Your health is restored to full.\n");
    }
    else 
    {
        _health += healthGain;
        printf("You have a chance to rest between fights.  You regain %i health.\n", healthGain);
    }
}

// Use this if you want a super long output of
// the entire experience ramp.
void player::displayExpRamp()
{
    printf("XP TO LEVEL:\n");
    
    _level = 0x01;
    
    unsigned long int xpToLevel = 0;
    unsigned int clump = 0;
    
    for(int i = 1; i < 256; i++)
    {
        _level = i;
        clump = PLAYER_XP_PER_LEVEL * _level;
        xpToLevel = ( (clump * clump * clump) + 360);
        printf("Level %i to %i:  %ul\n", _level, _level+1, xpToLevel);
    }
    
    _level = 0x01;
}

// Applies damage to player after
// doing a dodge roll.
void player::takeDamage(int roll)
{
    srand ( time(NULL) );
    int dodgeRoll = ( rand() % 1000 );
    
    int dodgeChance = 15 * _level;
    if(dodgeChance > 500) dodgeChance = 500;
    
    if(dodgeRoll > 1000 - dodgeChance)
    {
        printf("You have dodged the enemy's attack!\n");
        return;
    }
    
    _health -= roll;
    
    printf("You have taken %i damage!  (Current health:  %i)\n", roll, _health);
}

// Returns current player level
char player::getLevel()
{
    return _level;
}

// Function to communicate enemy info
// Use however you like or go with another method
void player::setCurrentEnemy(int health, char level)
{
    if(level)
    {
        _enemyLevel = level;
    }
    
    _enemyHealth = health;
}

// Checks to see if the player is dead and returns true if dead
// Also makes fun of you :)
char player::isDead()
{
    if(_health <= 0)
    {
        printf("\n\nOOOOOOOH!  So sorry, a loser is you!\n");
        printf("Stats:\n");
        printf("Current Level:  %i\n", _level);
        printf("Currrent XP:  %ul\n", _experience);
        wait(3);
        printf("Burning your useless body...\n");
        wait(1);
        printf("Cloning you (although we aren't sure why after that last failure)...\n");
        wait(2);
        printf("Ready to go!\n\n");
        return 0x01;
    }
    else
    {
        return 0x00;
    }
}













