#ifndef _LIFEENTITY_
#define _LIFEENTITY_

#include "mbed.h"

/** Base life entity class.
 * 
 * This class is inherited by all life entities (user, enemies, anything you can think of that 
 * is supposed to live).
 *
 * Example:
 * @code
 * // Create a pointer to a life_entity object.
 * life_entity *currentEnemy; 
 *
 * int main()
 * {    
 *     // Use the pointer to create a new armoured_vehicle (derived class)
 *     currentEnemy = new armoured_vehicle(user);
 * }
 * @endcode
 */
class life_entity
{

public:
    /** Base life entity class constructor.
     * 
     * This class is inherited by all life entities (user, enemies, anything you can think of that 
     * is supposed to live).
     *
     * Example:
     * @code
     * // Create a pointer to a life_entity object.
     * life_entity *currentEnemy; // Life entity object
     *
     * int main()
     * {    
     *     // Use the pointer to create a new armoured_vehicle (derived class)
     *     currentEnemy = new armoured_vehicle(user);
     * }
     * @endcode
     */
    life_entity();
    
    /** Base life entity class destructor.
     * 
     * This class is inherited by all life entities (user, enemies, anything you can think of that 
     * is supposed to live).
     *
     * Example:
     * @code
     * // Create a pointer to a life_entity object.
     * life_entity *currentEnemy; 
     *
     * int main()
     * {    
     *     // Use the pointer to create a new armoured_vehicle (derived class)
     *     currentEnemy = new armoured_vehicle(user);
     *
     *     delete currentEnemy;
     * }
     * @endcode
     */
     virtual ~life_entity();
    
    /** Get number of life entities currently spawned.
    * 
    *
    * Example:
    * @code
    * char count = getLifeEntityCount();
    * @endcode
    */
    char getLifeEntityCount();
    
    /** Returns the current status of the entity's life points.
    * 
    *
    * Example:
    * @code
    * int lifePoints = getHealth();
    * @endcode
    */
    int getHealth();
    
    /** Get the current level of the entity.
    * 
    * No error checking is performed.  If you wish to use this you
    * should consider adding a check or two.
    * The level is currently stored in a char, and therefore maxes
    * out at 255 (0xFF).
    *
    * Example:
    * @code
    * char currentLevel = getLevel();
    * @endcode
    */
    char getLevel();
    
    /** Entity rolls for damage.
    * 
    * All entities use this to roll for damage (against thier opponent).
    *
    * Example:
    * @code
    * int roll = rollDamage();
    * @endcode
    */
    int rollDamage();
    
    /** Take damage from apponent.
    *
    * Derived classes set this up on specific to thier needs.
    * 
    * @param roll The damage roll to be passed in (most likely from rollDamage()).
    *
    */
    virtual void takeDamage(int) { };
    
        
protected:
    /**
    * Entity health variable (int).
    */
    int _health;
    
    /**
    * Entity level variable (char).
    */
    char _level;
    
    /**
    * Static entity count variable (int).
    */
    static int lifeEntityCount;
    
};

#endif