#include "life_entity.h"

int life_entity::lifeEntityCount = 0;

// Constructor
// Sets up basic variables and adds to entity counter
life_entity::life_entity()
{
    _level = 0x01;
    
    _health = _level * 100;
    
    lifeEntityCount++;
}

// Destructor (virtual)
// Simply modifies the entity counter
life_entity::~life_entity()
{
    lifeEntityCount--;
}


// Return life entity count
char life_entity::getLifeEntityCount()
{
    return lifeEntityCount;
}

// Returns the current health of the entity
int life_entity::getHealth()
{
    return _health;
}

// Returns the level of the entity
char life_entity::getLevel()
{
    return _level;
}

// Roll for damage
// This is currently the same for all entities.
// Different damage is currently applied in main (like one third damage that user takes)
int life_entity::rollDamage()
{
    int maxDmg = 7;
    srand ( time(NULL) );
    
    int roll = (rand() % (maxDmg * _level) + 1);
    
    srand ( time(NULL) );
    
    int isCrit = ( rand() % 1000 + 1);
    
    if(isCrit >= 800)
    {
        isCrit = 1;
    }
    else
    {
        isCrit = 0;
    }
    
    if(isCrit)
    {
        printf("CRIT!\n");
        roll = (maxDmg * 2) - ( rand() % 4 + 1 );
    }
    
    return roll;
}