#include "enemy.h"

// Pointer to the player(user) class
player *pPlayer;

// Constructor
// Calculates enemy level flux (+/- 2 levels the way I did it)
// Initiates variables (including calculating health).
enemy::enemy(player *thePlayer)
{
    srand ( time(NULL) );
    
    int plusOrMinus = (rand() % 2);
    
    #if DEBUG_ENEMY_VERBOSE
    printf("Plus or Minus:  %i\n", plusOrMinus);
    #endif
    
    srand ( time(NULL) );
    int levelFlux = 0;
    
    if(plusOrMinus)
    {
        levelFlux = (rand() % 4 + 1) / 2;
    }
    else
    {
        levelFlux = -(rand() % 4 + 1) / 2;
    }
    
    #if DEBUG_ENEMY_VERBOSE
    printf("LevelFlux:  %i\n", levelFlux);
    #endif
    
    _level = thePlayer->getLevel() + levelFlux;
    
    while(_level <= 0)
    {
        srand ( time(NULL) );
        
        #if DEBUG_ENEMY_VERBOSE
        printf("Plus or Minus:  %i\n", plusOrMinus);
        #endif
        
        if(plusOrMinus)
        {
            levelFlux = (rand() % 4 + 1) / 2;
        }
        else
        {
            levelFlux = -(rand() % 4 + 1) / 2;
        }
        
        _level = thePlayer->getLevel() + levelFlux;
        
        if(_level > thePlayer->getLevel() + 2 || _level < thePlayer->getLevel() - 2)
        {
            _level = 0;
        }
    }
    
    _health = _level * 100;
    
    #if DEBUG_ENEMY
    printf("Creating enemy character @ level %i\n", _level);
    #endif
    
    printf("FIGHT!\n\n");
    wait(.5);
    
    pPlayer = thePlayer;
    
}

// Deconstructor
// Prints message to indicate death if health is less than zero.
// Skips the message if deleted before health reaches zero (or below).
enemy::~enemy()
{
    if(_health <= 0)
    printf("Oh noes!  You has killed meh...that's so mean.\n");
}


// Applies damage to enemy after
// doing a dodge roll.
void enemy::takeDamage(int roll)
{
    srand ( time(NULL) );
    int dodgeRoll = ( rand() % 1000 );
    
    int dodgeChance = 5 * _level;
    if(dodgeChance > 200) dodgeChance = 200;
    
    if(dodgeRoll > 1000 - dodgeChance)
    {
        printf("Enemy has dodged your attack!\n");
        return;
    }
    
    _health -= roll;
    
    printf("Enemy has taken %i damage!  (Current health:  %i)\n", roll, _health);
}
