#ifndef _ENEMYENTITY_
#define _ENEMYENTITY_

#include "mbed.h"
#include "life_entity.h"
#include "player.h"

#define DEBUG_ENEMY 0x01
#define DEBUG_ENEMY_VERBOSE 0x00

/** Enemy class (basic enemy) derived from life_entity.
 * 
 * This class is derived from life_entity.
 *
 * Example:
 * @code
 *
 * // Create a pointer to a life_entity object.
 * life_entity *currentEnemy; 
 *
 * int main()
 * {    
 *     // Use the pointer to create a new armoured_vehicle (derived class)
 *     currentEnemy = new enemy(user);
 * }
 * @endcode
 */
class enemy : public life_entity
{

public:

    /** Enemy class constructor.
     * 
     * This class is derived from life_entity.
     *
     * @param *thePlayer Pointer to the player's class.
     *
     * Example:
     * @code
     * // Create a pointer to a life_entity object.
     * life_entity *currentEnemy; // Life entity object
     *
     * int main()
     * {    
     *     // Use the pointer to create a new armoured_vehicle (derived class)
     *     currentEnemy = new enemy(user);
     * }
     * @endcode
     */
    enemy(player *thePlayer);
    
    /** Enemy class destructor.
     * 
     * This class is derived from life_entity.
     *
     * Example:
     * @code
     * // Create a pointer to a life_entity object.
     * life_entity *currentEnemy; 
     *
     * int main()
     * {    
     *     // Use the pointer to create a new armoured_vehicle (derived class)
     *     currentEnemy = new enemy(user);
     *
     *     delete currentEnemy;
     * }
     * @endcode
     */
    virtual ~enemy();
    
    /** Take damage from apponent.
    *
    * This applies the player's damage roll to the enemy's health after a dodge roll
    * is performed.
    * 
    * @param roll The damage roll to be passed in (most likely from rollDamage()).
    *
    * Example:
    * @code
    * player *user = new player();
    * life_entity *currentEnemy; 
    *
    * int main()
    * {    
    *     // Use the pointer to create a new armoured_vehicle (derived class)
    *     currentEnemy = new enemy(user);
    *     
    *     // User rolls for damage
    *     int roll = user->rollDamage();
    *     // Current enemy takes the hit
    *     currentEnemy->takeDamage(roll);
    * }
    * @endcode
    */
    virtual void takeDamage(int roll);
    
        
protected:
    
};

#endif