#include "armoured_vehicle.h"

// Pointer to the player (user) class
player *pThePlayer;


// Constructor
// Calculates enemy level flux (+/- 2 levels the way I did it).
// Initiates variables  (including calculating health and armour).
armoured_vehicle::armoured_vehicle(player *thePlayer)
{
    srand ( time(NULL) );
    
    int plusOrMinus = (rand() % 2);
    
    
    
    #if DEBUG_ARMOURED
    printf("%i\n", plusOrMinus);
    #endif
    
    srand ( time(NULL) );
    int levelFlux = 0;
    
    if(plusOrMinus)
    {
        levelFlux = (rand() % 4 + 1) / 2;
    }
    else
    {
        levelFlux = -(rand() % 4 + 1) / 2;
    }
    
    #if DEBUG_ARMOURED_VERBOSE
    printf("LevelFlux:  %i\n", levelFlux);
    #endif
    
    _level = thePlayer->getLevel() + levelFlux;
    
    while(_level <= 0)
    {
        srand ( time(NULL) );
        
        #if DEBUG_ARMOURED_VERBOSE
        printf("%i\n", plusOrMinus);
        #endif
        
        if(plusOrMinus)
        {
            levelFlux = (rand() % 4 + 1) / 2;
        }
        else
        {
            levelFlux = -(rand() % 4 + 1) / 2;
        }
        
        _level = thePlayer->getLevel() + levelFlux;
        
        if(_level > thePlayer->getLevel() + 2 || _level < thePlayer->getLevel() - 2)
        {
            _level = 0;
        }
    }
    
    _health = _level * 100;
    
    // Armour amount is really what decides how hard your elite enemies are.
    _armour = _level * 25;
    
    _armourBroken = 0x00;
    
    #if DEBUG_ARMOURED
    printf("Creating armoured vehicle character @ level %i\n", _level);
    #endif
    
    printf("FIGHT!\n\n");
    wait(.5);
    
    pThePlayer = thePlayer;
    
}

// Prints message to indicate death if health is less than zero.
// Skips the message if deleted before health reaches zero (or below).
armoured_vehicle::~armoured_vehicle()
{
    if(_health <= 0)
    printf("You blew up my tank!  Do you have any idea how much these things cost?\n");
}

// Applies damage to enemy after
// doing a dodge roll.
// Armoured vehicles take damage to armour before health.
void armoured_vehicle::takeDamage(int roll)
{
    srand ( time(NULL) );
    int dodgeRoll = ( rand() % 1000 );
    
    int dodgeChance = 5 * _level;
    if(dodgeChance > 200) dodgeChance = 200;
    
    if(dodgeRoll > 1000 - dodgeChance)
    {
        printf("Enemy has dodged your attack!\n");
        return;
    }
    
    if(_armourBroken == 0x00)
    {
        _armour -= roll;
        
        if(_armour > 0)
        {
            printf("Enemy armour has absorbed %i damage. (current armour:  %i)\n", roll, _armour);
            return;
        }
        else
        {
            
            printf("Enemy armour destroyed!\n");
            _armourBroken = 0x01;
            
            _health += _armour;
        }
    }
    
    
    _health -= roll;
    
    printf("Enemy has taken %i damage!  (Current health:  %i)\n", roll, _health);
}

