#ifndef _ARMOUREDENTITY_
#define _ARMOUREDENTITY_

#include "mbed.h"
#include "life_entity.h"
#include "player.h"

#define DEBUG_ARMOURED 0x01
#define DEBUG_ARMOURED_VERBOSE 0x00


/** Armoured Vehicle class (elite enemy) derived from life_entity.
 * 
 * This class is derived from life_entity.
 *
 * Example:
 * @code
 * // Create a pointer to a life_entity object.
 * life_entity *currentEnemy; 
 *
 * int main()
 * {    
 *     // Use the pointer to create a new armoured_vehicle (derived class)
 *     currentEnemy = new armoured_vehicle(user);
 * }
 * @endcode
 */
class armoured_vehicle : public life_entity
{

public:

    /** Armoured Vehicle class constructor.
     * 
     * This class is derived from life_entity.
     *
     * @param *thePlayer Pointer to the player's class.
     *
     * Example:
     * @code
     * // Create a pointer to a life_entity object.
     * life_entity *currentEnemy; // Life entity object
     *
     * int main()
     * {    
     *     // Use the pointer to create a new armoured_vehicle (derived class)
     *     currentEnemy = new armoured_vehicle(user);
     * }
     * @endcode
     */
    armoured_vehicle(player *thePlayer);
    
    /** Armoured Vehicle class destructor.
     * 
     * This class is derived from life_entity.
     *
     * Example:
     * @code
     * // Create a pointer to a life_entity object.
     * life_entity *currentEnemy; 
     *
     * int main()
     * {    
     *     // Use the pointer to create a new armoured_vehicle (derived class)
     *     currentEnemy = new armoured_vehicle(user);
     *
     *     delete currentEnemy;
     * }
     * @endcode
     */
    virtual ~armoured_vehicle();
    
    /** Take damage from apponent.
    *
    * A dodge roll is performed.  If the dodge roll succeeds the damage is avoided.
    * This applies the player's damage roll to the armoured vehicle's armour,
    * and after the armour is destroyed it applies it to the vehicle's health.
    * 
    * @param roll The damage roll to be passed in (most likely from rollDamage()).
    *
    * Example:
    * @code
    *
    * player *user = new player();
    * life_entity *currentEnemy; 
    *
    * int main()
    * {    
    *     // Use the pointer to create a new armoured_vehicle (derived class)
    *     currentEnemy = new armoured_vehicle(user);
    *     
    *     // User rolls for damage
    *     int roll = user->rollDamage();
    *     // Current enemy takes the hit
    *     currentEnemy->takeDamage(roll);
    * }
    * @endcode
    */
    virtual void takeDamage(int roll);
    
        
protected:

    /**
    * Variable to hold armour amount.
    */
    int _armour;
    /**
    * Variable flag to indicate if armour is broken or not.
    */
    char _armourBroken;
    
};

#endif