/*
    Object Oriented Programing Review

    Refreshing my memory on things I
    haven't touched since college.
    
    This version is intended for public use.
    You may use this in any way you choose, free of charge.
    No permission is required (written or verbal), and you
    do not HAVE to attribute.  It would however, be very
    nice if you would mention me in any product or project
    you may create with this.
    
    Aaron Goselin 2011
*/

#include "mbed.h"
#include "life_entity.h"
#include "player.h"
#include "enemy.h"
#include "armoured_vehicle.h"

Serial PC(USBTX, USBRX);

// Pointer to player's class
// Does not change to any other class
// Only resets on death (delete then new)
player *user = new player();

// Pointer to the current enemy.
// Can change from enemy to armoured_vehicle (or the other way around)
// Also resets on death (delete and new)
// Pointer to user class is always passed to the current enemy's
// constructor.
life_entity *currentEnemy;

int main() 
{
    PC.baud(230400);
    
    // Setting RTC for rand()
    set_time(1256729737);
    
    int enemyHealth = 0;
    char enemyLevel = 0x00;
    int roll = 0;  // Damage roll
    int roundCount = 1;  // Round counter
    char thereIsCake = 0x00;
    
    while(1) 
    {
        srand ( time(NULL) );
        // Spawn elite enemy
        if( (rand() % 1000) > 200 )
        {
            delete currentEnemy;
            currentEnemy = new armoured_vehicle(user);
        }
        // Spawn normal enemy
        else
        {
            delete currentEnemy;
            currentEnemy = new enemy(user);
        }
        
        enemyHealth = currentEnemy->getHealth();
        enemyLevel = currentEnemy->getLevel();
        
        // This isn't really used in the version of code
        // being added to the site but you can use it
        // however you like.
        user->setCurrentEnemy(enemyHealth, enemyLevel);
        
        // Keep going through the rounds until someone is dead
        while(currentEnemy->getHealth() > 0)
        {
            printf("ROUND #%i\n", roundCount);
            printf("----------\n");
            // User rolls for damage
            roll = user->rollDamage();
            // Current enemy takes the hit
            currentEnemy->takeDamage(roll);
            // Get current enemy health
            enemyHealth = currentEnemy->getHealth();
            // Send update on enemy health status to user
            user->setCurrentEnemy(enemyHealth);
            // Enemy rolls for damage
            roll = currentEnemy->rollDamage();
            // User takes the hit (one third of it anyway)
            user->takeDamage(roll / 3);
            // Check to see if the user is dead
            thereIsCake = user->isDead();
            // Exit if user is dead (they promised cake though)
            if(thereIsCake) break;
            wait(.5);
            
            roundCount++;
        }
        
        // If the user dies restart everything
        if(thereIsCake)
        {
            delete user;
            user = new player();
            roundCount = 1;
        }
        // User is still alive.  Crap, no cake yet.
        else
        {        
            // User won, so add xp (also adds a bit of health)
            user->addExperience();
            // Check to see if user leveled up
            user->isLevelUp();
            // Reset round counter
            roundCount = 1;
        }
        
    }
}
