#include "mbed.h"
#include "USBKeyboard.h"

USBKeyboard M;      //Configura la salida USB como un teclado.

DigitalOut B(LED3);      //Permite controlar el LED azul.
DigitalOut W(LED1);      //Permite controlar el led rojo.

DigitalIn L(A0);
DigitalIn U(A1);       //Estas 4 entradas serán las cuatro direcciones.
DigitalIn R(A2);
DigitalIn D(A3);

int main()
{
    while(1)
    {
        B=0;           //El led azul indica que el sistema funciona.
        W=1;
        
        if (L==0)   //Al oprimir el botón de la entrada L, se mueve el cursor 30 unidades a la izquierda.
        {
            M.keyCode(LEFT_ARROW,0);        //El movimiento se especifica de la forma -y,-x.
            wait(1);
        }
        if (U==0)
        {
            M.keyCode(UP_ARROW,0);
            wait(1);
        }
        if (R==0)
        {
            M.keyCode(RIGHT_ARROW,0);
            wait(1);
        }
        if (D==0)
        {
            M.keyCode(DOWN_ARROW,0);
            wait(1);
        }
        else
        {
            W=0;
        }
    }
}