#include "mbed.h"

//Esta entrada recibe la señal cardiaca amplificada.
AnalogIn S(A0);


//Salidas:

//Se usa el led para indicar el estado del sistema.
DigitalOut Red(LED1);
DigitalOut Grn(LED2);                      
DigitalOut Blu(LED3);

//Debido a que no se espera que una frecuencia cardiaca sea mayor que 199, se usan dos Bus para contolar displays de 7 segmentos que expresan
//las decenas y unidades de la misma, y un LED para indicar si esta contiene una centena o no.
BusOut dec(D0,D1,D2,D3,D4,D5,D6);
BusOut uni(D8,D9,D10,D11,D12,D13,D14);
DigitalOut cen(D7);


//Variables:

float f=0;                  //La frecuencia promedió durante el último ciclo de medición.
float crit=0.5f;            //Voltaje crítico: valor con el que se compara S para determinar si hay un pulso o no.
int t=0;                    //Almacena el tiempo transcurrido en el ciclo de medición.
int p=0;                    //Cuenta la cantidad de pulsos que han ocurrido en el ciclo.
int v0=0;                   //Indica si el valor actual de S es mayor que el voltaje crítico.
int v1=0;                   //Conserva el valor de v0 en la iteración anterior del ciclo.
int r=5;                    //Resolución: la longitud en segundos del ciclo de medición.
int u=0;                    //Las unidades del valor de f.
int d=0;                    //Las decenas del valor de f.
int c=0;                    //Las centenas del valor de f.
int ub=0;                   //El número a escribir en el Bus de las unidades para desplegarlas en su display correspondiente.
int db=0;                   //El número a escribir en el Bus de las decenas para desplegarlas en su display correspondiente.
int cb=0;                   //Toma un valor de 0 si la frecuencia no tiene centenas y de 1 en caso contrario.


//Misceláneo:

Timer tmr;                  //Un temporizador determina cuándo se termina cada ciclo de medición.


//Funciones:

void R()                    //Se utiliza para indicar que hay un error, el LED indicador permanece en rojo hasta que se reinicia el sistema.
{
    while(1)
    {
        Red=0;
        Grn=1;
        Blu=1;
    }
}

void G()                    //Estado natural del indicador. Se usa para decir que el sistema está encendido y funcionando, pero no se encuentra en ninguno de los otros estados.
{
    Red=1;
    Grn=0;
    Blu=1;
}

void B()                    //El indicador se enciende en azul para indicar que S es mayor que el voltaje crítico, durante un pulso.
{
    Red=1;
    Grn=1;
    Blu=0;
}

void getf()                 //Get Frequency: Esta función calcula la frecuencia promedio de la señal S en un intervalo dado por la resolución r.
{
    tmr.reset();            //Al inicio de cada ciclo de medición se reinicia el temporizador.
    p=0;
    while(t<r)              //La duración del ciclo está dada por r.
    {
        v1=v0;              //Al comienzo de cada iteración, v1 adquiere el valor que tenía v0.
        if(S.read()>crit)   
        {
            v0=1;           //Cuando S supera al voltaje crítico, v0 toma un valor de 1
            if (v0>v1)      //La primera vez que sucede esto, se cuenta el pulso.
            {
                p++;
            }
            else            //De la segunda vez consecutiva en adelante, el indicador marca que hay un pulso.
            {
                B();
            }
        }
        else                //Una vez que S se encuentra por debajo del valor crítico, v0 vuelve a ser 0 y el inicador vuelve a su estado natural.
        {
            v0=0;
            G();
        }
        t=tmr.read();       //El rastreo del temporizador se hace después de cada medición.
    }
    G();                    //El indicador es azul únicamente si hay un pulso y se está midiendo.
    f=(60/r)*(p/t);         //La expresión p/t es la frecuencia en pulsos cada ciclo, por lo que se multiplica por 60/r para obtener ppms.
    c=floor(f/100);
    d=floor(f/10)-(10*c);   //se separan el valor de f en centenas, decenas y unidades.
    u=f-(10*d)-(100*c);
}

void printd()               //Print Display: Despliega el valor los valores de c, d y u en sus correspondientes salidas.
{
    if(c<2)                 //Normalmente, c es binario, por lo que se avisa de un error caso contrario
    {
        if(c==0)
        {
            cb=0;           //cb será el valor que tome la salida digital de las centenas.
        }
        else if(c==1)
        {
            cb=1;
        }
        else
        {
            R();
        }
    }
    else
    {
        R();
    }
    
    if(d==0)                //Para cada valor que pueden tomar los dígitos hay un número decimal que se debe aplicar al Bus para desplegarlo.
    {
        db=119;
    }
    else if(d==1)
    {
        db=36;
    }
    else if(d==2)
    {
        db=93;
    }
    else if(d==3)
    {
        db=109;
    }
    else if(d==4)
    {
        db=46;
    }
    else if(d==5)
    {
        db=107;
    }
    else if(d==6)
    {
        db=123;
    }
    else if(d==7)
    {
        db=37;
    }
    else if(d==8)
    {
        db=127;
    }
    else if(d==9)
    {
        db=111;
    }
    else
    {
        R();
    }
    
    if(u==0)                //Lo mismo sucede para las unidades que para las decenas. Se indica error en caso de que alguna variable tome un valor no válido.
    {
        ub=119;
    }
    else if(u==1)
    {
        ub=36;
    }
    else if(u==2)
    {
        ub=93;
    }
    else if(u==3)
    {
        ub=109;
    }
    else if(u==4)
    {
        ub=46;
    }
    else if(u==5)
    {
        ub=107;
    }
    else if(u==6)
    {
        ub=123;
    }
    else if(u==7)
    {
        ub=37;
    }
    else if(u==8)
    {
        ub=127;
    }
    else if(u==9)
    {
        ub=111;
    }
    else
    {
        R();
    }
    cen.write(cb);
    dec.write(db);          //Finalmente, se envia cada valor a la salida correspondiente.
    uni.write(ub);
}

int main()
{
    G();
    tmr.start();            //El temporizador se inicia una sola vez, antes de entrar en el bucle de funcionamiento.
    while(1)                //Se alterna entre medición de frecuencia y despliegue de información.
    {
        getf();
        printd();
    }
}