#include "mbed.h"

#define WHEEL_1_ADDRESS 0xA0
#define WHEEL_2_ADDRESS 0xA2
#define WHEEL_3_ADDRESS 0xA4
#define CATAPULT_ADDRESS 0xA6

Serial xbee(D8, D2);
I2C i2c(D14, D15);

DigitalOut start_led(D13);
DigitalOut receive_led(D12);

int button_data[8];

int wheel_1_data = 0x30;
int wheel_2_data = 0x30;
int wheel_3_data = 0x30;
int catapult_data = 0x30;

int dummy_rcvdata = 0xFF;
int button_rcvdata = 0xFF;
int RJ_rcvdata = 0x00;
int LJ_rcvdata = 0x00;

void data_receive(){
    dummy_rcvdata = 0xFF;
    button_rcvdata = 0xFF;
    RJ_rcvdata = 0x00;
    LJ_rcvdata = 0x00;
    dummy_rcvdata = xbee.getc();
    if(dummy_rcvdata == 0x00){
        button_rcvdata = xbee.getc();
        RJ_rcvdata = xbee.getc();
        LJ_rcvdata = xbee.getc();

        receive_led = 1;
    }
    else{
        receive_led = 0;
    }
}

void setup(){
    xbee.baud(9600);
    xbee.attach(data_receive, Serial::RxIrq);
    start_led = 1;
}

void data_analyze(){

    wheel_1_data = 0x30;
    wheel_2_data = 0x30;
    wheel_3_data = 0x30;
    catapult_data = 030;

    int num = 128;
    for(int i = 7;i >= 0;i--){
        if(button_rcvdata >= num){
            button_rcvdata = button_rcvdata - num;
            button_data[i] = 1;
        }
        else{
            button_data[i] = 0;
        }

        num = num / 2;
    }
    if(button_data[2] == 1){
        catapult_data = 0x17;
    }
    else{
        catapult_data = 0x30;
    }

    

    /*if(LJ_rcvdata > 31){
        LJ_rcvdata = LJ_rcvdata * 0b00001111;
    }

    if(LJ_rcvdata > 31){
        wheel_1_data = 0x25;
        wheel_2_data = 0x25;
        wheel_3_data = 0x25;
    }
    else if(LJ_rcvdata > 16){
        wheel_1_data = 0x23;
        wheel_2_data = 0x23;
        wheel_3_data = 0x23;
    }
    else if((LJ_rcvdata < 14) && (LJ_rcvdata > 10)){
        wheel_1_data = 0x30;
        wheel_2_data = 0x30;
        wheel_3_data = 0x30;
    }
    else if(LJ_rcvdata > 8){
        wheel_1_data = 0x13;
        wheel_2_data = 0x13;
        wheel_3_data = 0x13;
    }
    else{
        wheel_1_data = 0x15;
        wheel_2_data = 0x15;
        wheel_3_data = 0x15;
    }*/

    if(RJ_rcvdata > 0.9){
        wheel_2_data = 0x1A;
        wheel_3_data = 0x2A;
    }
    else if(RJ_rcvdata > 0.8){
        wheel_2_data = 0x19;
        wheel_3_data = 0x29;
    }
    else if(RJ_rcvdata > 0.7){
        wheel_2_data = 0x18;
        wheel_3_data = 0x28;
    }
    else if(RJ_rcvdata > 0.6){
        wheel_2_data = 0x17;
        wheel_3_data = 0x27;
    }
    else if(RJ_rcvdata == 0.5){
        wheel_2_data = 0x30;
        wheel_3_data = 0x30;
    }
    else if(RJ_rcvdata < 0.4){
        wheel_2_data = 0x27;
        wheel_3_data = 0x17;
    }
    else if(RJ_rcvdata < 0.3){
        wheel_2_data = 0x28;
        wheel_3_data = 0x18;
    }
    else if(RJ_rcvdata < 0.2){
        wheel_2_data = 0x29;
        wheel_3_data = 0x19;
    }
}

void i2c_send(int address, int data){
    i2c.start();
    i2c.write(address);
    i2c.write(data);
    i2c.stop();
}

void i2c_allsend(){
    i2c_send(WHEEL_1_ADDRESS,wheel_1_data);
    i2c_send(WHEEL_2_ADDRESS,wheel_2_data);
    i2c_send(WHEEL_3_ADDRESS,wheel_3_data);
    i2c_send(CATAPULT_ADDRESS,catapult_data);
}

int main(){
    setup();
    while(1){
        data_analyze();
        //i2c_allsend();
        i2c_send(WHEEL_1_ADDRESS,0x11);
        i2c_send(WHEEL_2_ADDRESS,0x30);
        i2c_send(WHEEL_3_ADDRESS,0x30);
        i2c_send(CATAPULT_ADDRESS,0x30);
        wait(0.5);
        i2c_send(WHEEL_1_ADDRESS,0x30);
        i2c_send(WHEEL_2_ADDRESS,0x11);
        i2c_send(WHEEL_3_ADDRESS,0x30);
        i2c_send(CATAPULT_ADDRESS,0x30);
        wait(0.5);
        i2c_send(WHEEL_1_ADDRESS,0x30);
        i2c_send(WHEEL_2_ADDRESS,0x30);
        i2c_send(WHEEL_3_ADDRESS,0x11);
        i2c_send(CATAPULT_ADDRESS,0x30);
        wait(0.5);
        i2c_send(WHEEL_1_ADDRESS,0x30);
        i2c_send(WHEEL_2_ADDRESS,0x30);
        i2c_send(WHEEL_3_ADDRESS,0x30);
        i2c_send(CATAPULT_ADDRESS,0x11);
        wait(0.5);
    }
}