#include "mbed.h"
#include "LSM9DS1.h"
#include "FastPWM.h"
#include <math.h>
/*
    HOW TO CHANGE SETTING:
    1. Put "true" only in one of the next lines (15-18)
    2. Put "true" or "false" on PS_MODE if it's necessary (line 20)
    3. If using analog accelerometr - change "calibreted counts" according to the table(lines 23-28)
    4. If using optical transmitting choose PWM_MODE - 455 or 38 for 455 kHz and 38 kHz pwm (line 41)
       Also if using optical transmitting choose BAUD_RATE 4800 for 38 kHz
                                                        or 4800, 9600, 19200, 38400 for 455 kHz (line42)
*/
// setting of MIX DEVICE 
#define DA_PS_BT false //Digital Accelerometer + Pulse Sensor + Bluetooth
#define AA_PS_BT fasle// Analog Accelerometer + Pulse Sensor + Bluetooth
#define DA_PS_Op false//Digital Accelerometer + Pulse Sensor + Optical
#define AA_PS_Op true// Analog Accelerometer + Pulse Sensor + Optical

#define PS_MODE false // On/Off Pulse Sensor (
#define PS_PIN A3 //Pulse Sensor pin

float X0 = 1.68;  //calibrated counts of analog Accelerometer
float Y0 = 1.69;
float Z0 = 1.70;
float Sx = 0.69;
float Sy = 0.70;
float Sz = 0.68;

#define ACC_X_PIN A6
#define ACC_Y_PIN A5 //Analog Accelerometer pins
#define ACC_Z_PIN A4


#define BT_TX_PIN PA_9 // Bluetooth pins
#define BT_RX_PIN PA_10

#define OPT_TX_PIN A7 //A7 optical pins, pwm, baudrate
#define OPT_RX_PIN A2

#define PWM_MODE 455
#define BAUD_RATE 4800
#define PWM_PIN D10 //D10


#if (DA_PS_Op || DA_PS_BT) 
    LSM9DS1 acc(D4, D5);
#endif

#if (AA_PS_BT || DA_PS_BT) // uart's init
    Serial pc(SERIAL_TX, SERIAL_RX); // tx, rx
    Serial BT(BT_TX_PIN, BT_RX_PIN); // tx, rx  
    //RawSerial pc2(A7,NC,115200); // if necessary run second uart
    float acc_x,acc_y,acc_z;
#endif

#if (AA_PS_Op || DA_PS_Op)
    Serial Serial2(OPT_TX_PIN,NC,BAUD_RATE);
    //RawSerial pc(D1,NC,BAUD_RATE); // if necessary run second uart
    uint16_t acc_x,acc_y,acc_z;
#endif

#if (AA_PS_BT || AA_PS_Op)
    AnalogIn X(ACC_X_PIN);
    AnalogIn Y(ACC_Y_PIN);
    AnalogIn Z(ACC_Z_PIN);
#endif

#if (PS_MODE)
    AnalogIn P(PS_PIN);
#endif

DigitalOut myled(LED1, 1);

PwmOut buzz(A1);

float ARes = 2.0 / 32768.0; // Digital ACC have datatype int16_t 
int Signal = 0;
int OldSignal = 0;
int total = 0;
int Maxn = 0;
int average = 0;
int IsoLine = 0;
int Tpulse = 0;
int Tpulse1 = 0;
int Tpulse2 = 0;
int Tpulse22;
int PulseOK = 0;
int AccData[3];
unsigned int  trame1,trame2,trame3,trame4,trame5,trame6,trame7,trame8,trame9,tramePULSE;
int cptmesure;
Timer T1;
float delta;
double Last, Now;
bool START = false;
int coun;
float tableau_x[10], tableau_y[10], tableau_z[10], t_delta[10];
int numReadings = 500;
int Index = 0;
int readings[500];
int IndexBPM = 5;
int IndexB = 0;
int readingsBPM[5];
int k;
int totalBPM;
int averageBPM;
int verif;
int patient;
bool a = true; 

void setup()
{
    #if (AA_PS_Op || DA_PS_Op)
        FastPWM mypwm(PWM_PIN,1); //Initializing of clock Output
        //Clock settings for 38kHz
        if (PWM_MODE == 38)
        {
            mypwm.period_us(26.3158);
            mypwm.pulsewidth_us(13.1579);//Duty-Cycle 50% here
        } 
        //Clock settings for 455kHz
        if (PWM_MODE == 455)
        {
            mypwm.period_us(2.1978);
            mypwm.pulsewidth_us(1.0989);//Duty-Cycle 50% here
        }
    #endif
    
    #if (AA_PS_BT || DA_PS_BT)
        BT.baud(115200);
        pc.baud(115200); // Start serial at 115200 bps
    #endif
      
    #if (DA_PS_BT || DA_PS_Op)
         acc.setAcceleroRange(LSM9DS1_ACCELERO_RANGE_2G);
    #endif
    buzz.period_us(2272.7f);
    buzz.write(0.0f);
}
#if (PS_MODE)
int readMean(int samples)
{
    int sum = 0;
    for (int i = 0; i < samples; i++)
        sum = sum + (4096*P.read());
    return sum/samples;
}

void pulse()
{
    Signal =  readMean(30);
    total = total - readings[Index];
    readings[Index] = Signal;
    total = total + readings[Index];
    Index = Index + 1;           
    if (Index >= numReadings) Index = 0;
    Maxn = 0;
    for (int i = 0; i < numReadings; i++)
    {
        if (readings[i]>Maxn)
        Maxn =  readings[i];
    }                      
    average = total/numReadings;
    IsoLine =  average +  ((Maxn - average)*0.5);
    
    if ((Signal > IsoLine) && (OldSignal < IsoLine))
    {
        if (k > 0)
        {
            T1.stop();
            Tpulse1 = T1.read_ms();
            Tpulse = Tpulse2 + Tpulse1;
            Tpulse22 = 60*1000L/Tpulse;
            if (Tpulse22 > 40 && Tpulse22 < 240)
                PulseOK = Tpulse22;
            T1.reset();
            T1.start();
            k--;
        }
    }
    else
    {
        if((Signal < IsoLine) && (OldSignal > IsoLine))
        {
            if (k < 1) 
            {
                T1.stop();
                Tpulse2 = T1.read_ms();
                T1.reset();
                T1.start();
                k++;
            }
        }
    }
    OldSignal = Signal;
}
#endif
void matrice_euler()
{
    tableau_x[coun-1]=acc_x;
    tableau_y[coun-1]=acc_y;
    tableau_z[coun-1]=acc_z;
    t_delta[coun-1]=delta;
}

void read_capteur()
{
    #if (DA_PS_BT) //Digital acc init
        acc_x = -acc.getAcceleroRawY()*ARes;    // !!axis directions are correct!!
        acc_y =  acc.getAcceleroRawX()*ARes;    // !!axis directions are correct!!
        acc_z =  acc.getAcceleroRawZ()*ARes;    // !!axis directions are correct!!
    #elif (AA_PS_BT)                            // !!axis directions are correct!!
        acc_x = ((double)Y.read()*3.3-Y0)/Sy;   // !!axis directions are correct!!
        acc_y = -((double)X.read()*3.3-X0)/Sx;  // !!axis directions are correct!!
        acc_z = -((double)Z.read()*3.3-Z0)/Sz;  // !!axis directions are correct!!
    #elif (AA_PS_Op)                            // !!axis directions are correct!!
        acc_x = Y.read_u16();                   // !!axis directions are correct!!
        acc_y = -X.read_u16();                  // !!axis directions are correct!!
        acc_z = -Z.read_u16();                  // !!axis directions are correct!!
    #elif (DA_PS_Op)                            // !!axis directions are correct!!
        acc_x = -acc.getAcceleroRawY();         // !!axis directions are correct!!
        acc_y =  acc.getAcceleroRawX();         // !!axis directions are correct!!
        acc_z =  acc.getAcceleroRawZ();         // !!axis directions are correct!!
    #endif
}

void loop ()
{
    read_capteur();
    matrice_euler();
    
    #if (AA_PS_BT || DA_PS_BT)
        if (coun>=10)
        {
            char s1[50]; //size of the number
            char s2[50]; 
            char s3[50]; 
            char s4[50];
            char s5[50];
    
            myled=!myled;
            coun=0;
            for(int i=0; i<10; i++)
            {
                sprintf(s1, "%g", tableau_x[i]);
                sprintf(s2, "%g", tableau_y[i]);
                sprintf(s4, "%g", tableau_z[i]);
                sprintf(s3, "%g", t_delta[i]);
                #if (PS_MODE)
                    sprintf(s5, "%d", PulseOK);
                    BT.printf("%s;%s;%s;%s;%s|", s1,s2,s4,s3,s5);
                #endif
                #if (!PS_MODE)
                    BT.printf("%s;%s;%s;%s|", s1,s2,s4,s3);
                #endif
            }
        }
    #endif
    #if (DA_PS_Op || AA_PS_Op)
            //increment of measurement: avoids the redundancy of the display on the server
            cptmesure++;
            if(cptmesure == 8) cptmesure = 0;
                
            trame2 = (acc_x & 0xFF00) >> 8;         // xxxx xxxx xxxx xxxx -> xxxx xxxx 0000 0000 -> 0000 0000 xxxx xxxx
            trame3 = (acc_x & 0xFF);                // xxxx xxxx xxxx xxxx -> 0000 0000 xxxx xxxx
            trame4 = (acc_y & 0xFF00) >> 8;         // same trame2
            trame5 = (acc_y & 0xFF);                // same trame3
            trame6 = (acc_z & 0xFF00) >> 8;         // same trame2
            trame7 = (acc_z & 0xFF);                // same trame3
            
            verif =  (trame2 << 3) + cptmesure; // xxxx xxxx -> xxx xxxx x000 -> xxx xxxx xccc
                                                
            //first frame: patient + verif (2 bits high)
            trame1 = (patient << 4) + ((verif & 0x700) >> 7);// 0000 pppp -> pppp 0000 -> vvv vvvv vvvv -> vvv 0000 0000 -> 0000 0vvv -> pppp vvv0
            
            trame8 = (verif & 0xFF);// vvv vvvv vvvv -> vvvv vvvv  mask 1111 1111
            
            //fifth frame: patient + increment measurement
            trame9 = (patient << 4) + (cptmesure << 1); // 0000 pppp -> pppp 0000 -> 0000 0ccc -> 0000 ccc0 -> pppp ccc0
            
/*         IMPORTANT TO UNDERSTAND (ONLY FOR NUCLEO)
            TrameTab[0] = 255;  
            TrameTab[1] = trame1;
            TrameTab[2] = trame2;   
            TrameTab[3] = trame3;
            TrameTab[4] = trame8;
            TrameTab[5] = trame9;
            //Serial2.write(TrameTab,6,0,0);
            //IF we will use write() then sketch will stuck after 166 seconds. putc() working same as write().
*/
            Serial2.putc(255);
            Serial2.putc(trame1);
            Serial2.putc(trame2);
            Serial2.putc(trame3);
            Serial2.putc(trame4);
            Serial2.putc(trame5);
            Serial2.putc(trame6);
            Serial2.putc(trame7);
            #if (PS_MODE)
                Serial2.putc((uint8_t)PulseOK);
            #endif
            Serial2.putc(trame8);
            Serial2.putc(trame9);
            #if (!PS_MODE)
                switch(BAUD_RATE)
                {
                    case 4800 :
                        //wait_us(20000);
                        wait_us(41666.66);
                        wait_us(3200);                    
                        break;
                    case 9600 :
                        wait_us(20833.33);
                        wait_us(1100);
                        break;
                    case 19200 :
                        wait_us(10416.66);
                        wait_us(200);
                        break;
                    case 38400 :
                        wait_us(4836.6);//data transfer compensation -351.7us for 38400 baud and 5208.3us delay
                                         //for using the same resistor that we use for optical ECG we should save the equation T_delay = 2*T_transmission 
                        break;
                    default :
                        wait_ms(50);
                 }
             #endif
             
             #if (PS_MODE)
                 switch(BAUD_RATE)
                 {
                    case 4800 :
                        //wait_us(20000);
                        wait_us(41666.66 + 4166.66);
                        wait_us(3200 + 320);                    
                        break;
                    case 9600 :
                        wait_us(20833.33 + 2083.33);
                        wait_us(1100 + 110);
                        break;
                    case 19200 :
                        wait_us(10416.66 + 1041.66);
                        wait_us(200 + 20);
                        break;
                    case 38400 :
                        wait_us(4836.6 + 520.83);//data transfer compensation -351.7us for 38400 baud and 5208.3us delay
                                         //for using the same resistor that we use for optical ECG we should save the equation T_delay = 2*T_transmission 
                        break;
                    default :
                        wait_ms(50);
                  }
             #endif
    #endif
}

int main()
{
    setup();
    #if (AA_PS_BT || DA_PS_BT)
        t.start();
        Last = t.read_us();
        coun=0;
        //count3=0;
    #endif

    while (true)
    {
        #if (PS_MODE)
            pulse();
        #endif
        #if (AA_PS_BT || DA_PS_BT) //bluetooth mode
            Now = t.read_us();
            delta = (float)(Now-Last)/1000000.0f;
            if (delta>=0.1f && START==true)
            {
                Last=Now;
                coun+=1;
                loop(); //Get sensor values
            }
            if (BT.readable())
            {
                char c = BT.getc();
                if(c == '1'){
                    START=true;
                }
                if(c == '0')
                {
                    START=false;
                    myled=1;
                    buzz.write(0.50f);
                    wait(3);
                    buzz.write(0.0f);
                }
            }
        #endif
        #if(DA_PS_Op || AA_PS_Op)
            loop();//optical
        #endif
    } 
}

