#include "mbed.h"
#include "FastPWM.h"
#define A_PIN A0
#define TX_PIN D1
#define RX_PIN D0
#define PWM_PIN D10
#define PWM_MODE 455
#define BAUD_RATE 38400

// https://developer.mbed.org/forum/electronics/topic/15346/
//------------------------------------
//Emission pgrm for the patient transmetting device. It uses the source code 
//originally made for Arduino. It has been first designed by S.Sahuguede
//------------------------------------
 /* 23.11.2018 sketch modified by Kostiantyn Vasko 
 * Transmitting by IR LED with 38kHz/455kHz Freq FOR STM32
 * Important pins:
 * D10 - PWM
 * A0 - Analog input for ECG
 */
 
Serial Serial2(TX_PIN,RX_PIN,BAUD_RATE);

//Initializing of clock Output
FastPWM mypwm(PWM_PIN,1);

//init variables 
int cptmesure = 0;
uint16_t analogin;

//VALUE TO MODIFY BY PATIENT
unsigned int patient=2;

//creation of variables for transmission control
int verif;
DigitalOut myled(D11);
AnalogIn X(A_PIN);
    
int main() {
    //pwm_io(16, 0.5); //26.041 us with a duty cycle of 50% ==> Here I get 38kHz as Output with 16µs...
    
    //Bytes variables which gonna be sent
    unsigned int  trame1,trame2,trame3,trame8, trame9;
    
    //Serial Com data sent
    //uint8_t TrameTab[6]; 
    
    //Clock settings for 38kHz
    if (PWM_MODE == 38)
    {
        mypwm.period_us(26.3158);
        mypwm.pulsewidth_us(13.1579);//Duty-Cycle 50% here
    } 
    //Clock settings for 455kHz
    if (PWM_MODE == 455)
    {
        mypwm.period_us(2.1978);
        mypwm.pulsewidth_us(1.0989);//Duty-Cycle 50% here
    }
    
    while(1) 
    {
        analogin = (uint16_t) (65535 * X);// Read ECG signal and transforming into digit.

        trame2=(analogin & 0xFF00) >> 8;         // mask 1111 1111 0000 0000 (ECG signal 16 bit)
        trame3=(analogin & 0xFF);                // mask 0000 0000 1111 1111 
          
        //increment of measurement: avoids the redundancy of the display on the server
        cptmesure++;
        if(cptmesure==8)
        {
            cptmesure=0;
        }
          
        verif =  (trame2 << 3) + cptmesure ; 
        
        //first frame: patient + verif (2 bits high)
        trame1= (patient << 4) + ((verif & 0x700)>>7);//mask 111 0000 0000
        
        trame8= (verif & 0xFF);//mask 1111 1111
        
        //fifth frame: patient + increment measurement
        trame9= (patient << 4) + (cptmesure << 1);
        
       /* TrameTab[0] = 255;  
        TrameTab[1] = trame1;
            
        TrameTab[2] = trame2;   
        TrameTab[3] = trame3;
            
        TrameTab[4] = trame8;
        TrameTab[5] = trame9;
        */
        
        //Serial2.write(TrameTab,6,0,0);
        
        //IF we will use write() then sketch will stuck after 166 seconds. putc() working same as write().
        
        Serial2.putc(255);
        Serial2.putc(trame1);
        Serial2.putc(trame2);
        Serial2.putc(trame3);
        Serial2.putc(trame8);
        Serial2.putc(trame9);
        
        switch(BAUD_RATE)
       {
         case 4800 :
                wait_ms(4);  //data transfer compensation 4ms    for 4800  baud and 25ms    delay
                wait_ms(25);
                break;
         case 9600 :
                wait_ms(2.5);//data transfer compensation 2.5ms  for 9600  baud and 12.5ms  delay
                wait_ms(12.5);
                break;
         case 19200 :
                wait_ms(1.25);//data transfer compensation 1.25ms for 19200 baud and 6.25ms  delay
                wait_ms(6.25);
                break;
         case 38400 :
                wait_ms(1.25);//data transfer compensation 1.25ms for 38400 baud and 3.125ms delay
                wait_ms(3.125);
                break;
         case 57600 :
                wait_us(400);//data transfer compensation 1.25ms for 38400 baud and 3.125ms delay
                wait_us(2084);
                break;
          default :
                wait_ms(50);
        }
    }
}