#include "mbed.h"
#include "USBSerial.h"
#include "SDFileSystem.h"

#define     CW      0x01
#define     CCW     0x02
#define     STOP    0x03
#define     FREE    0x00

DigitalOut  led(P1_28);
DigitalOut  cs0(P0_20);

DigitalIn   sw(P0_1);

PwmOut      pwm(P1_26);

USBSerial   vcom;

Timer t;

SPI         spi(P1_22, NC, P1_15);
BusOut      mdrive0(P1_19, P1_25);

SDFileSystem sd(P0_9, P0_8, P1_29, P1_31, "sd");

union MCP4922
{
    uint16_t command;
    struct
    {
        //DAC data bits
        uint16_t    D   :12;
        //Output power down control bit
        uint8_t     SHDN:1;
        //Outout gain select bit
        uint8_t     GA  :1;
        //Vref input buffer Control bit
        uint8_t     BUF :1;
        //DACa or DACb select bit
        uint8_t     AB  :1;
    }bit;
};
union MCP4922 dac = {0xF7F};

void systeminit();

int main(){
    uint16_t velocity = 0;
    char str[64];
    systeminit();
    mdrive0 = CW;
    pwm = 0.2;
    while(1){
        led = !led;
        velocity += 100;
        if(velocity > 4095) velocity = 0;
        dac.bit.D = velocity;
        cs0 = 0;
        spi.write(dac.command);
        cs0 = 1;
        if(sw == 0){
            mkdir("/sd/mydir", 0777);
            
            FILE *fp = fopen("/sd/mydir/sdtest.txt", "w");
            if(fp == NULL)
            {
                vcom.printf("Could not open file for write\n");
                break;
            }
            t.start();
            fprintf(fp, "Hello fun SD");
            t.stop();
            fclose(fp);
            vcom.printf("The time taken was %d micro seconds\n", t.read_us());
            vcom.printf("goodbye\n");
            
            while(sw == 0){}
        }
        wait(0.1);
    }
}

void systeminit(){
    sw.mode(PullUp);
    wait(0.1);
    cs0 = 1;
    dac.bit.AB = 0;
    dac.bit.BUF = 1;
    dac.bit.GA = 1;
    dac.bit.SHDN = 1;
    dac.bit.D = 1024;
    spi.format(16,0);
    spi.frequency(20000000);
    cs0 = 0;
    spi.write(dac.command);
    cs0 = 1;
}