#include "mbed.h"
#include "TextLCD.h"

I2CSlave i2cslave(dp5, dp27);

DigitalOut led1(dp14);

TextLCD lcd(dp17, dp18, dp25, dp10, dp26, dp28, TextLCD::LCD20x4); // rs, e, d4-d7

Serial pc(dp16, dp15);

int main() {
    char str[20], serBuff[64];
        float SystemVoltage, AverageCellVoltage, MaxCellVoltage, MinimumCellVoltage,
    SystemCurrent, Motor1Current, Motor2Current, Motor3Current,
    Remain, PowerConsumption, IntegralPowerConsumption, IntegralCurrent;

    int measCurrent, currentCmd, accelVol, pwmDuty, mtrRpm;
    
    int MaxCellNumber, MinimumCellNumber;
    int32_t cellvol[12], mincell, maxcell;
    float realcellvol;  /* real number of cell voltage */

    char rbuf[8];
    char i2cbuf[32] = {0};
    char *endPtr;

    SystemVoltage = 120.5;      //%4.1f システム電圧
    AverageCellVoltage = 3.123; //%4.3f 平均セル電圧
    MaxCellVoltage = 1.234;     //%4.3f 
    MinimumCellVoltage = 0.123; //%4.3f
    MaxCellNumber = 5;          //%1d
    MinimumCellNumber = 3;      //%1d
    SystemCurrent = 138.1235;   //%3.0f
    Motor1Current = 11.1245;    //%3.0f
    Motor2Current = 22.1245;    //%3.0f
    Motor3Current = 33.1245;    //%3.0f
    Remain = 85.435;            //%3.0f
    PowerConsumption = 12.54;   //%4.2f
    IntegralPowerConsumption = 1.54; //%3.2f
    IntegralCurrent = 43.21;    //%4.2f
    
    pc.baud(38400);

    lcd.cls();
    led1 = 0;
    lcd.locate( 0, 0);
    lcd.printf("rcv start");
    wait(0.5);
    led1 = 1;



    while(1){
        //---------------------------------------------
        // 文字列受信=>数値変換
        //---------------------------------------------
        led1 = !led1;
        pc.scanf("%s", serBuff);
        if( 's' == serBuff[0] ){
        // 文字列解釈
            //電流計測値(AD10bit生データ)
            strncpy( rbuf, &serBuff[1], 4 );
            measCurrent = ( strtol( rbuf, &endPtr, 10) );
            memset( rbuf, '\0', sizeof rbuf );
            //電流指令値(倍率が正しくないと思う)
            strncpy( rbuf, &serBuff[5], 4 );
            currentCmd = ( strtol( rbuf, &endPtr, 10) );
            memset( rbuf, '\0', sizeof rbuf );
            //ボリューム(AD10bit生データ)
            strncpy( rbuf, &serBuff[9], 4 );
            accelVol = ( strtol( rbuf, &endPtr, 10) );
            memset( rbuf, '\0', sizeof rbuf );
            //PWMデューティ(0~800:MAX800)
            strncpy( rbuf, &serBuff[13], 4 );
            pwmDuty = ( strtol( rbuf, &endPtr, 10) );
            memset( rbuf, '\0', sizeof rbuf );
            //モータ回転数(RPM)
            strncpy( rbuf, &serBuff[17], 6 );
            mtrRpm = ( strtol( rbuf, &endPtr, 10) );
            memset( rbuf, '\0', sizeof rbuf );
            // 数値表示
            lcd.cls(); //<=表示クリア
            lcd.locate( 0, 0); //<= locate(列，行)
            lcd.printf("SC  =%04dA", measCurrent ); 
            lcd.locate( 0, 1);
            lcd.printf("cmd =%04dA", ((measCurrent - currentCmd) / 4) );
            lcd.locate( 0, 2);
            lcd.printf("vol =%04d", accelVol );
            lcd.locate( 0, 3);
            lcd.printf("duty=%04.1f%", ((float)(pwmDuty))/8 );
            lcd.locate( 10, 0);
            lcd.printf("%06drpm", mtrRpm );
        }
//        wait(0.1);

    }
}