#include "mbed.h"

#define FREE    0x00
#define CW      0x01
#define CCW     0x02
#define STOP    0x03

DigitalIn   sw(P0_1, PullUp);
DigitalOut  led(P1_28);

SPI spi(P1_22, NC, P1_15);
DigitalOut cs0(P0_20);
DigitalOut cs1(P0_2);
BusOut  mtrdrv0(P1_19, P1_25);
BusOut  mtrdrv1(P1_16, P0_19);
BusOut  mtrdrv2(P0_18, P0_17);


union MCP4922
{
    uint16_t command;
    struct
    {
        //DAC data bits
        uint16_t    D   :12;
        //Output power down control bit
        uint8_t     SHDN:1;
        //Outout gain select bit
        uint8_t     GA  :1;
        //Vref input buffer Control bit
        uint8_t     BUF :1;
        //DACa or DACb select bit
        uint8_t     AB  :1;
    }bit;
};

union MCP4922 dac = {0xF7F};

void systeminit();

int main(){
    systeminit();
    mtrdrv0 = CW;
    while(1){
        dac.bit.D += 1;
        if(dac.bit.D == 4095){
            dac.bit.D = 0;
            led = !led;
        }
        cs0 = 0;
        spi.write(dac.command);
        cs0 = 1;
        wait(0.001);
    }
}

void systeminit(){
    mtrdrv0 = FREE;
    mtrdrv1 = FREE;
    mtrdrv2 = FREE;
    cs0 = 1;
    cs1 = 1;
    dac.bit.AB = 0;
    dac.bit.BUF = 1;
    dac.bit.GA = 1;
    dac.bit.SHDN = 1;
    dac.bit.D = 0;
    spi.format(16,0);
    spi.frequency(20000000);
    cs0 = 0;
    spi.write(dac.command);
    cs0 = 1;
    dac.bit.AB = 1;
    cs0 = 0;
    spi.write(dac.command);
    cs0 = 1;
    dac.bit.AB = 0;
    cs1 = 0;
    spi.write(dac.command);
    cs1 = 1;
    dac.bit.AB = 1;
    cs1 = 0;
    spi.write(dac.command);
    cs1 = 1;
}
