#include "MotorDriver_SU.h"

SPI spi(P1_22, NC, P1_15);
BusOut  MotorDirect_A(P1_19, P1_25, P1_16, P0_19);
BusOut  MotorDirect_B(P0_18, P0_17, P1_14, P1_13);

MotorDriver_SU::MotorDriver_SU(PinName chip) : _chip(chip){
    if (chip == P0_2){
        MotorDirect = &MotorDirect_B;
    }else{
        MotorDirect = &MotorDirect_A;
    }
    (*MotorDirect) = FREE;
    _chip = 1;
    dac.bit.AB = 0;
    dac.bit.BUF = 1;
    dac.bit.GA = 1;
    dac.bit.SHDN = 1;
    dac.bit.D = 0;
    spi.format(16,0);
    spi.frequency(20000000);
    _chip = 0;
    spi.write(dac.command);
    _chip = 1;
    dac.bit.AB = 1;
    _chip = 0;
    spi.write(dac.command);
    _chip = 1;
}
void MotorDriver_SU::Drive(uint8_t channel, uint8_t direction, uint16_t velocity){
    dac.bit.AB = (channel ^ 0x01);
    dac.bit.D = velocity;
    _chip = 0;
    spi.write(dac.command);
    _chip = 1;
//    (*MotorDirect) = ((*MotorDirect) & (0x0F & (0x0F << (channel * 2)))) | (direction <<(channel * 2));
    (*MotorDirect) = ((*MotorDirect) & (0x0C >> (channel * 2))) | (direction << (channel * 2));
}
