#ifndef MBED_MOTORDRIVER_SU_H_
#define MBED_MOTORDRIVER_SU_H_

#include "mbed.h"

#define MOTOR_SINGLE    P0_2
#define MOTOR_DOUBLE    P0_20

#define FREE    0x00
#define CW      0x01
#define CCW     0x02
#define STOP    0x03

class MotorDriver_SU{
public:
    MotorDriver_SU(PinName chip);
    void Drive(uint8_t channel, uint8_t direction, uint16_t velocity);
    
private:
    
    BusOut * MotorDirect;
    DigitalOut  _chip;
    
    
    union MCP4922
    {
        uint16_t command;
        struct
        {
            //DAC data bits
            uint16_t    D   :12;
            //Output power down control bit
            uint8_t     SHDN:1;
            //Outout gain select bit
            uint8_t     GA  :1;
            //Vref input buffer Control bit
            uint8_t     BUF :1;
            //DACa or DACb select bit
            uint8_t     AB  :1;
        }bit;
    };
    union MCP4922 dac;
};

#endif