#include "mbed.h"
#include "LTC6803.h"
#define BMS_NUM 2

DigitalOut myled(LED1);
SPI spi(dp2, dp1, dp6); // mosi, miso, sclk
DigitalOut cs(dp4);

Serial pc(dp16, dp15);  //制御基板とのシリアル接続

unsigned char CalcCRCLTC6803(unsigned char * dat, unsigned char numdat);

//-----------------------------------------
// グローバル変数
//-----------------------------------------
// CRC演算用変数
static unsigned char crc8_table[256];      // 8-bit table for PEC calc
static int made_table = 0;         // table made flag
unsigned char packet[18]={0};               // used for PEC calc
unsigned char PECbyte;                                                   // PEC of a byte
unsigned char PECpacket;                // PEC of packet
unsigned char PECpacketREAD;             // value that PECpacket should be as read from 6803
// 制御基板との通信確率フラグ
static unsigned char comFlag = 0;

static void init_crc8();
void setPECbyte(unsigned char m);
void setPECpacket(unsigned char np);

static void init_crc8() {
   int z,j;
   unsigned char cr;
   if (!made_table) {
      for (z = 0; z < 256; z ++) {
         cr = z;
         for (j = 0; j < 8; j ++) {
            cr = (cr << 1) ^ ((cr & 0x80) ? 0x07 : 0);
         }
         crc8_table[z] = cr & 0xFF;
      }
      made_table = 1;
   }
}

void setPECbyte(unsigned char m) {
   PECbyte = 0x41;                   // initialize PECbyte
   if (!made_table) {
      init_crc8();
   }
   PECbyte = crc8_table[(PECbyte) ^ m];
}

void setPECpacket(unsigned char np) {            // np is number of bytes currently in packet[]
   int z;
   PECpacket = 0x41;                  // initialize PECpacket
   if (!made_table) {
      init_crc8();
   }
   for (z = 0; z < np; z ++) {
      PECpacket = crc8_table[(PECpacket) ^ packet[z]];
   }
}
unsigned char CalcCRCLTC6803(unsigned char * dat, unsigned char numdat){
    unsigned char pec;
    char loop, outerloop;
    datainput in;
    in.byte = 0;
    pec = CRCDEFAULT;
    for(outerloop = 0; outerloop < numdat; outerloop++){
        for(loop = 8; loop > 0; loop--){
            in.in.b0 = (dat[outerloop] >> (loop - 1)) ^ ((pec >> 7));
            in.in.b1 = in.in.b0 ^ (pec);
            in.in.b2 = in.in.b0 ^ (pec >> 1);
            pec = pec << 1;
            pec = (pec & 0xF8) | (in.byte & 0x07);
        }
    }
    return pec;
}

//-----------------------------------------
// 制御基板からの受信割り込みサービスルーチン
//-----------------------------------------
void pcRxISR() {
    if(pc.getc() == 's'){
        comFlag = 1;
        myled = 1;
    }else{
        comFlag = 0;
    }
}


int main() {
    unsigned char cmd, tmp, datnum, getpec;
    unsigned char dat[16], getdat[18][BMS_NUM];
//    float cellvol[4];
    int cellvol[12][BMS_NUM];
    int cellallvol, cellMinVol, cellMaxVol;
    char str[32];
    cs = 1;
    spi.format(8,3);
    spi.frequency(500000);
    pc.baud(115200);
    
    cs = 0;
    cmd = WRCFG;
    spi.write(cmd);
    spi.write(CalcCRCLTC6803(&cmd, 1));
    dat[0] = 0x02;
    dat[1] = 0x00;
    dat[2] = 0x00;
    dat[3] = 0xff;
    dat[4] = 42;
    dat[5] = 255;
    for(int loop_1 = 0; loop_1 < BMS_NUM; loop_1++){
        for(int loop = 0;loop < 6; loop++){
            spi.write(dat[loop]);
        }
        cmd = CalcCRCLTC6803(dat, 6);
        spi.write(cmd);
    }
    cs = 1;
    wait(0.001);
    while(1) {
        cs = 0;
        cmd = RDCV;
        spi.write(cmd);
        spi.write(CalcCRCLTC6803(&cmd, 1));
        for(int bms = 0; bms < BMS_NUM; bms++){
            for(int cell = 0;cell < 18; cell++){
                getdat[cell][bms] = spi.write(0);
            }
            getpec = spi.write(0);
        }
        cs = 1;
        wait(0.001);
        cs = 0;
        cellallvol = 0;
        cellMinVol = getdat[0][0];
        cellMaxVol = getdat[0][0];
        for(int bms = 0; bms < BMS_NUM; bms++){
            cellvol[0][bms] = (((getdat[1][bms] & 0x0f) << 8) | getdat[0][bms]);
            cellvol[1][bms] = ((getdat[2][bms] << 4) | ((getdat[1][bms] & 0xf0) >> 4));
            cellvol[2][bms] = (((getdat[4][bms] & 0x0f) << 8) | getdat[3][bms]);
            cellvol[3][bms] = ((getdat[5][bms] << 4) | ((getdat[4][bms] & 0xf0) >> 4));
            cellvol[4][bms] = (((getdat[7][bms] & 0x0f) << 8) | getdat[6][bms]);
            cellvol[5][bms] = ((getdat[8][bms] << 4) | ((getdat[7][bms] & 0xf0) >> 4));
            cellvol[6][bms] = (((getdat[10][bms] & 0x0f) << 8) | getdat[9][bms]);
            cellvol[7][bms] = ((getdat[11][bms] << 4) | ((getdat[10][bms] & 0xf0) >> 4));
            cellvol[8][bms] = (((getdat[13][bms] & 0x0f) << 8) | getdat[12][bms]);
            cellvol[9][bms] = ((getdat[14][bms] << 4) | ((getdat[13][bms] & 0xf0) >> 4));
            cellvol[10][bms] = (((getdat[16][bms] & 0x0f) << 8) | getdat[15][bms]);
            cellvol[11][bms] = ((getdat[17][bms] << 4) | ((getdat[16][bms] & 0xf0) >> 4));
            for(int loop = 0;loop < (12); loop++){
                cellallvol += cellvol[loop][bms];
                // セル最低電圧 最高電圧判定
                if (cellMinVol > cellvol[loop][bms])
                {
                    cellMinVol = cellvol[loop][bms];
                }
                if (cellMaxVol < cellvol[loop][bms])
                {
                    cellMaxVol = cellvol[loop][bms];
                }
            }
        }
        //======================================================================
        // 制御基板との通信確立時に制御基板へ計測データを送信する
        //======================================================================
        if( 1 == comFlag ){
            wait(0.05);
            for (uint8_t bms = 0; bms < BMS_NUM; ++bms)
            {
                for(uint8_t cellNumForLoop = 0; cellNumForLoop < 12; cellNumForLoop++){
                    pc.printf("%d\n", cellvol[cellNumForLoop][bms]);
                }
            }
            pc.printf("%d\n", cellMinVol);
            pc.printf("%d\n", cellMaxVol);
            pc.printf("%d\n", cellallvol / ( BMS_NUM * 12 ) );
            comFlag = 0;
            myled = 0;
        }

        cmd = STCVADALL;
        
        spi.write(cmd);
        spi.write(CalcCRCLTC6803(&cmd, 1));
        cs = 1;
        wait(0.4);
    }
}
