#include "mbed.h"

BusOut leds(P1_13, P1_14, P1_22, P0_17, P0_18, P0_19, P1_15, P0_1);

void single(unsigned char bit);
void all();
void rotate();

int main()
{

    while(1)
    {
        single(0);
        wait(2);
        all();
        all();
        all();
        rotate();
        rotate();    
    }
}

void single(unsigned char bit)
{
    leds = 1 << bit;
}
void all()
{
    leds = 0x0;
    wait(0.5);
    leds = 0xff;
    wait(0.5);
}
void rotate()
{
    volatile uint8_t i;
    for(i = 0x00; i < 8; i++)
    {
        leds = 1 << i;
        wait(0.125);
    }
}