#include "mbed.h"

#define STOP    0
#define CW      1
#define CCW     2
 
Serial pc(dp16, dp15); // tx, rx

PwmOut pincw(dp1), pinccw(dp2);

int main() {
    char cmd[64];
    int rpm, pulsewidth, waittime, rounddirection = STOP;
    pc.baud(115200);
    pincw.write(0);
    pinccw.write(0);
    pincw.period_us(1500);
    while(1) {
        pc.scanf("%s", cmd);
        pc.scanf("%d", &rpm);
        pulsewidth = 1000000 / (rpm * 720 / 60);
        if(strncmp(cmd,"CW", 2) == 0){
            pinccw.write(1);
            wait_us(200);
            pincw.period_us(pulsewidth);
            pincw.write(0.5);
            rounddirection = CW;
            pc.printf("OK\n");
        }else if(strncmp(cmd,"CCW", 3) == 0){
            pincw.write(1);
            wait_us(200);
            pinccw.period_us(pulsewidth);
            pinccw.write(0.5);
            rounddirection = CCW;
            pc.printf("OK\n");
        }else if(strncmp(cmd,"STOP", 4) == 0){
            pinccw.write(1);
            pincw.write(1);
            rounddirection = STOP;
            pc.printf("OK\n");
        }else{
            pinccw.write(1);
            pincw.write(1);
            rounddirection = STOP;
            pc.printf("NG\n");
        }
    }
}
