#include "mbed.h"
#include "ESP8266.h"
#include <string>
#include <stdio.h>
#define APIKEY 5ZVYJP19NQZJHIJM    //Put "Write key" of your channel in thingspeak.com 
#define IP "184.106.153.149"       // IP Address of "api.thingspeak.com\"
#define WIFI_SSID "iphone"
#define WIFI_PASS "priyanka2024"


char snd[255],rcv[1000],snd_Data[255];
int cnt;


ESP8266 esp(PTC17, PTC16, 115200); // baud rate for wifi
Serial pc(USBTX, USBRX);

InterruptIn motion(D2);
int motion_detected = 0;
void irq_handler(void)
{
motion_detected = 1;
}
void esp_initialize(void);
void esp_send(void);

int main(void)
{   
pc.baud(115200);
    esp_initialize();

 cnt = 0;     
motion.rise(&irq_handler);          
while(1)
 {        
 if(motion_detected) 
{            
 cnt++;           
  motion_detected = 0;            
 printf("Hello! I've detected %d times since reset\n", cnt); 
printf("Now uploading status to cloud\n\r");
    
   
    esp_send();
   }
 }
}

void esp_initialize(void)
{
    //AT+CWJAP="priyanka2024","iPhone" ;
    
    pc.printf("Initializing ESP\r\n");
    pc.printf("Reset ESP\r\n");
    esp.Reset();                   //RESET ESP
    esp.RcvReply(rcv, 400);        //receive a response from ESP
    wait(2);

    strcpy(snd,"AT");
    esp.SendCMD(snd);
    pc.printf(snd);
    esp.RcvReply(rcv, 400);
    pc.printf(rcv);
    wait(2);

    strcpy(snd,"AT+CWMODE=1");
    esp.SendCMD(snd);
    pc.printf(snd);
    wait(2);

    strcpy(snd,"AT+CWJAP=\"");
    strcat(snd,WIFI_SSID);
    strcat(snd,"\",\"");
    strcat(snd,WIFI_PASS);
    strcat(snd,"\"");

    esp.SendCMD(snd);
    pc.printf(snd);
    wait(5);
    esp.RcvReply(rcv, 400);
    pc.printf("\n %s \n", rcv);

    strcpy(snd,"AT+CIPMUX=1");
    esp.SendCMD(snd);
    pc.printf(snd);
    esp.RcvReply(rcv, 400);
    pc.printf("\n %s \n", rcv);
}

void esp_send(void)
{
    //ESP updates the Status of Thingspeak channel//

    strcpy(snd,"AT+CIPSTART=");
    strcat(snd,"\"TCP\",\"");
    strcat(snd,IP);
    strcat(snd,"\",80");

    esp.SendCMD(snd);
    pc.printf("Send\r\n%s",snd);
    esp.RcvReply(rcv, 1000);
    pc.printf("Receive\r\n%s",rcv);
    wait(2);

    
    pc.printf("Sending this information to thingspeak.com \r\n");
    sprintf(snd,"GET https://api.thingspeak.com/update?api_key=5ZVYJP19NQZJHIJM&field1=%d\r\n", cnt);
    //wait(5);
    //https://api.thingspeak.com/update?api_key=5ZVYJP19NQZJHIJM&field1=%d\r\n", cnt
    
    int i=0;
    for(i=0; snd[i]!='\0'; i++);
    i++;
    char cmd[255];

    sprintf(cmd,"AT+CIPSEND=%d",i);           //Send Number of open connection and Characters to send
    esp.SendCMD(cmd);
    pc.printf("Send\r\n%s",cmd);
    while(i<=20 || rcv == ">")
    {
        esp.RcvReply(rcv, 1000);
        wait(100);
        i++;
    }
    pc.printf("Receive\r\n%s",rcv);

    esp.SendCMD(snd);       //Post value to thingspeak channel
    pc.printf("Send\r\n%s",snd);

    while(i<=20 || rcv == "OK") 
    {
        esp.RcvReply(rcv, 1000);
        wait(100);
        i++;
    }
    pc.printf("Receive\r\n%s",rcv);
    
}





