/*
                FERNANDEZ-CLERICI
                  EJER03 - TP01

PTB0 -- Cable 1 (CONECTADO A GND)
PTB1 -- Cable 2 (CONECTADO A GND)
PTB3 -- Cable 3 (CONECTADO A GND)
PTB4 -- Cable 4 (CONECTADO A GND)

D8   -- Habilitacion Display 1
D9   -- Habilitacion Display 2

        Display 7 Segmentos

D10  -- Segmento a
D11  -- Segmento b
D2   -- Segmento c
D3   -- Segmento d
D4   -- Segmento e
D5   -- Segmento f
D6   -- Segmento g


*/

/*Incluyo las Librerias*/
#include "mbed.h"
#include "tsi_sensor.h"
#include "Led7Seg.h"

/* Declaraciones pertinentes al TSI */
#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
#define ELEC0 9
#define ELEC1 10
#elif defined (TARGET_KL05Z)
#define ELEC0 9
#define ELEC1 8
#else
#error TARGET NOT DEFINED
#endif

TSIAnalogSlider tsi(ELEC0, ELEC1, 40);

/*Maquina de estados Principal*/
#define INICIO      0
#define RESET       1
#define JUEGO       2
#define PERDER      3
#define GANAR       4
#define ESPERA      5

/*Maquina de estados de los displays*/
#define Unidades 0
#define Decenas  1
#define Espera   3

int ac = 0; //Acumulador de la maquina de displays
int ED = 0; //Variable de estado de la maquina de displays

Led7Seg disp(D9,D10,D2,D3,D4,D5,D6,1);  //Instancio el display
unsigned char u = 0, d = 0;
/*Seteo las habilitaciones*/
DigitalOut H1(D8);
DigitalOut H2(D7);


#define CANTCABLES 4  //Cantidad de cables con los que funcionara el sistema
#define TIEMPO     60 //Cantidad de segundos que tengo para desactivar la secuencia

/*Declaracion LEDs*/
DigitalOut Rojo(LED1);
DigitalOut Verde(LED2);
DigitalOut Azul(LED3);

/*Declaraciones Entradas...*/
DigitalIn C1(PTB0);
DigitalIn C2(PTB1);
DigitalIn C3(PTB2);
DigitalIn C4(PTB3);

/*Instancio los Timmer*/
Ticker ti;
Ticker D;
Ticker BC;

int estado = INICIO, tespera = 0;
int semilla = 0, tiempo = 0, cp = 0;
int sec[CANTCABLES+1] = {0};
bool loop1 = 1, loop2 = 1, parpadeo = 0;
int pos = 1, ant = 0;
bool estadop = 0;
float tsii = 0;

int tmo = TIEMPO;       //Variable de la cuenta regresiva
bool entmo = 0;         //Habilitacion de la cuenta regresiva..

/*Prototipos funciones*/
void leds(int num);                     //Controlador del LEd
void bombita ();                        //Maquina de estados principal
void temporizar();                      //Funcion relacionada al Timmer
bool isPart(int numero, int vector[]);  //Me notifica si un numero forma parte de un vector
int cables();                           //Me devuelve un num binario en resultado a todos los cables
char desc();
void Displays(unsigned char num, bool blink);   //Maquina de estados de manejo de los displays
void tim_D(void);                               //Timmer de los displays
void seg(void);                                 //Timmer cuenta regresiva
void Generosecuencia();                         //Genero la secuencia

int main()
{
    /*Inicializo los Ticker*/
    ti.attach(&temporizar, 0.1);
    D.attach(&tim_D,0.001);
    BC.attach(&seg,1);

    /*Seteo los Pull Ups INTERNOS para los cables*/
    C1.mode(PullUp);
    C2.mode(PullUp);
    C3.mode(PullUp);
    C4.mode(PullUp);

    /*Mensaje de inicio...*/
    leds(0b111);
    printf("Toque el TOUCH para comenzar: \r\n");

    while (true) {
        //Ejecuto la maquina de estados principal..
        bombita();
        //Ejecuto la maquina de estados de los displays
        Displays(tmo,parpadeo);
    }
}

void bombita ()
{
    int  g = 1;
    
    switch(estado) {
        default:
        case INICIO:
            tiempo = 0;
            parpadeo = 0;
            entmo = 0;  //No descuento ahora...
            /*Me fijo si apretaron el tsi*/
            tsii = tsi.readPercentage();
            if((tsii < 0.99)&&(tsii > 0.01)) {
                if (cables() == 0b0000) {
                    leds(0b000);
                    estado = RESET;
                    printf("Comencemos: \r\n\n");
                } else {
                    if(loop1) {
                        printf("CONECTE TODOS LOS CABLES >:(\r\n\n");
                        loop1 = 0;
                    }
                }
            } else {
                loop1 = 1;
            }
            break;
        case RESET:
            //Reinicio la secuencia
            Generosecuencia();
            printf("La secuencia es:  CABLE %d - CABLE %d - CABLE %d - CABLE %d \r\n\n", sec[1], sec[2], sec[3], sec[4]);
            entmo = 1;  //Empieza la cuenta regresiva...
            estado = JUEGO;
            /*Reinicio el tmo*/
            tmo = TIEMPO;
            pos = 1;
            break;
        case JUEGO:
            //Paso 1
            g = desc();

            if(((g != sec[pos]) && (g != 0)) || (tmo == 0)) {
                //Perdiste
                estado = PERDER;
                entmo = 0;  //No descuento ahora...
                break;
            }

            if(g == sec[pos]) {
                //Pase de nivel
                printf("MUY BIEN ZAFASTE POR AHORA :(\r\n\n");
                pos++;
            }


            if(cables() == 0b1111 && pos != 1) {
                //Gane!
                entmo = 0;  //No descuento ahora...
                estado = GANAR;
                printf("GANASTEE!! :)\r\n\n");
                printf("Reconecte los cables para volver a jugar\r\n");
                break;
            }

            break;
        case PERDER:
            //Perdiste
            if(loop2) {
                leds(4);
                printf("BOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOM!\r\n");
                printf("Perdiste bro :)\r\n\n");
                printf("Reconecte los cables para volver a jugar\r\n");
                parpadeo = 1;
                loop2 = 0;
            }
            if(tiempo == 5)
                leds(0b100);
            if(tiempo == 10) {
                leds(0b000);
                tiempo = 0;
            }
            //Si me reconectan todos los cables vuelvo al inicio...
            if(cables() == 0b0000) {
                estado = ESPERA;
                tespera = 0;
                loop2 = 1;
            }

            break;

        case GANAR:
            //Ganastee
            leds(0b010);
            //Hacer parpadear disply
            parpadeo = 1;
            //Si me conectan todos los cables reinicio...
            if(cables() == 0b0000) {
                estado = 8;
                tespera = 0;
            }

            break;

        case ESPERA:
            //Espero un toque para reiniciar y avisoo..
            leds(0b111);

            if(tespera > 20) {
                tmo = TIEMPO;
                printf("Reset! Toque el TOUCH para iniciar\r\n\n");
                semilla = 0;
                estado = INICIO;
                tespera = 0;
                semilla = 0;
                tiempo = 0;
                cp = 0;
                loop1 = 1;
                loop2 = 1;
                parpadeo = 0;
                pos = 1;
                ant = 0b0000;
            }
            break;
    }
}

void leds(int num)
{
    switch(num) {
        case 0:
            Rojo = 1;
            Verde = 1;
            Azul = 1;
            break;
        case 4:
            Rojo = 0;
            Verde = 1;
            Azul = 1;
            break;
        case 2:
            Rojo = 1;
            Verde = 0;
            Azul = 1;
            break;
        case 1:
            Rojo = 1;
            Verde = 1;
            Azul = 0;
            break;
        case 7:
            Rojo = 0;
            Verde = 0;
            Azul = 0;
            break;
    }
}


int cables()
{
    return (C1 | C2 << 1 | C3 << 2 | C4 << 3);
}

bool isPart(int numero, int vector[])
{
    int c = 0;
    for(c = 1; c <= 4; c ++) {
        if(numero == vector[c])
            return 1;
    }
    return 0;
}

char desc()
{
    static int validacion = 0;
    int ant1 = cables();

    //Cable 1
    if(((ant & 0001) != C1) && validacion != 1) {
        validacion = 1;
        return 1;
    }
    //Cable 2
    if((((ant >> 1) & 0001) != C2) && validacion != 2) {
        validacion = 2;
        return 2;
    }
    //Cable 3
    if((((ant >> 2) & 0001) != C3) && validacion != 3) {
        validacion = 3;
        return 3;
    }
    //Cable 4
    if((((ant >> 3) & 0001) != C4) && validacion != 4) {
        validacion = 4;
        return 4;
    }

    ant = ant1;

    return 0;
}

void temporizar()
{
    //Funcion de parpadeo
    if(parpadeo) {
        cp ++;
        if(cp > 10) {
            estadop = !estadop;
            cp = 0;
        }
    } else {
        //Apago todo lo que parpadea de forma definitiva
        estadop = 0;

    }
    tiempo ++;
    semilla++;
    tespera++;
}


void Displays(unsigned char num, bool blink)
{

    /*Si supero lo maximo que puedo mostrar parpadeo y pongo el max*/
    if(num > 99) {
        num = 99;
        blink = 1;
    }

    /*Maquina de estados*/
    switch(ED) {

        /*Calculo y coloco las unidades*/
        case Unidades:
            u = num % 10;
            disp.write(u);
            H1 = 1;

            if(ac >= 15) {
                H1 =  0;
                ED =  Decenas;
                ac = 0;
                break;
            }

            break;

        /*Calculo y coloco las decenas*/
        case Decenas:
            d = int(num/10) ;
            disp.write(d);
            H2 = 1;

            /*Transicion comun*/
            if(ac >= 15 && blink == 0) {
                H2 =  0;
                ED =  Unidades;
                ac = 0;
                break;
            }

            /*Transicion al estado de espera para blink*/
            if(ac >= 15 && blink) {
                H2 =  0;
                ED =  Espera;
                ac = 0;
                break;
            }

            break;

        case Espera:
            if(ac >= 200) {
                ac = 0;
                ED = Unidades;
                break;
            }
            break;
    }

}

void tim_D(void)
{
    ac++;
}

void seg(void)
{
    if(tmo > 0 && entmo )
        tmo--;
}

void Generosecuencia()
{
    int i = 1, u = 0;
    
    srand (semilla); ///Reinicio la semilla
    
    memset(sec, 0, sizeof(sec));
    
    while(i <= 4) {
        u = rand() % 4 + 1;
        if(!(isPart(u,sec))) {
            sec[i] = u;
            i++;
        }
    }

}