//inputs VCC, Step_Num, Dir
#include "mbed.h"
#define Double_Step_Num 8 // double stall check steps
#define Threshold 0.05f //400mA average current in one pulse. Aref to VDD
#define ADC_Meas_Time 41 // ADC one meas. time in us
const int MOSFET = 0x00ff0000; // driver pins
const int Full_Step[5] = {0x00AA0000, 0x00330000, 0x00C30000, 0x00CC0000, 0x003C0000}; // motor control commands
float VCC = 2.6;
unsigned int Step_Num = 2000;
unsigned int Max_Steps = 0;
bool Dir = 1; // direction of motor movement
float Pulse_Length = pow((3.2/VCC),2)*1500; // pulse lenght in us
unsigned int ADC_MAX = (int)(Pulse_Length/ADC_Meas_Time);
unsigned int i = 0;
PortOut DriverPins(Port0, MOSFET); // set driver pins as outputs
AnalogIn ADC(A1); //ADC pin, read Current
//////////////////////////////////////////////////////////////////////////////////
bool DoubleCheckStall()
{
    for (int Count = 1; Count <= 2; ++Count)
    {        
        for(int Step = 1; Step <= Double_Step_Num; ++Step)
        {
            if(!Dir)
            {
                if(i >= 4)
                {
                    i = 1;
                }
                else
                {
                    i++;
                }
            }
            else
            {
                if(i <= 1)
                {
                    i = 4;
                }
                else
                {
                    i--;
                }
            }
                DriverPins = Full_Step[i];
                wait_us(ADC_MAX*ADC_Meas_Time);
        }
        DriverPins = Full_Step[0];
        ///////////////////////////// reverse Dir move
        for(int Step = 1; Step <= Double_Step_Num + 8; ++Step)
        {
            if(Dir)
            {
                if (i >= 4)
                {
                    i = 1;
                }
                else
                {
                    i++;
                }                
            }
            else
            {
                if (i <= 1)
                {
                    i = 4;
                }
                else
                {
                    i--;
                }
            }
            
            float Full = 0;
            float Average = 0;
            DriverPins = Full_Step[i];
            if (Step > 3)
            {
                unsigned int ADC_Count = 0;
                while (ADC_Count < ADC_MAX)
                {
                    ADC_Count++;
                    Full = Full+ADC;
                }
                Average = Full/ADC_MAX;
                if (Average > Threshold)
                {
                    DriverPins = Full_Step[0];
                    return 1;
                }
            }
            else
            {
                wait_us(ADC_MAX*ADC_Meas_Time);
            }
        }
        DriverPins = Full_Step[0];
    }
    return 0;
}
/////////////////////////////////////////////////////////////////////////////////////
bool MotorMoveForward()
{
    bool Double_Stall = 0;
    float Average = 0;
    for (int Step = 1; Step <= Step_Num; Step++)
    {
        if (i >= 4)
        {
            i = 1;
        }
        else
        {
            i++;
        }
        float Full = 0;
        DriverPins = Full_Step[i];
        if (Step > 3)
        {
            unsigned int ADC_Count = 0;
            while (ADC_Count < ADC_MAX)
            {
                ADC_Count++;
                Full = Full+ADC;
            }
            Average = Full/ADC_MAX;
            if (Average > Threshold)
            {
                DriverPins = Full_Step[0];
                //wait (1);
                Double_Stall = DoubleCheckStall();
                if (Double_Stall)
                {
                    Max_Steps = Step;
                    return 1;
                }
                else
                {
                    Step = Step - 4;
                    continue;
                }
            }
        }
        else
        {
            wait_us(ADC_MAX*ADC_Meas_Time);
        }
    }
    DriverPins = Full_Step[0];
    return 0;
}
///////////////////////////////////////////////////////////////////////////////////////////////
bool MotorMoveReverse()
{
    bool Double_Stall = 0;
    float Average = 0;
    for (int Step = 1; Step <= Step_Num; Step++)
    {
        if (i <= 1)
        {
            i = 4;
        }
        else
        {
            i--;
        }
        float Full = 0;
        DriverPins = Full_Step[i];
        if (Step > 3)
        {
            unsigned int ADC_Count = 0;
            while (ADC_Count < ADC_MAX)
            {
                ADC_Count++;
                Full = Full+ADC;
            }
            Average = Full/ADC_MAX;
            if (Average > Threshold)
            {
                DriverPins = Full_Step[0];
                //wait(1);
                Double_Stall = DoubleCheckStall();
                if (Double_Stall)
                {
                    return 1;
                }
                else
                {
                    Step = Step - 4;
                    continue;
                }
            }
        }
        else
        {
            wait_us(ADC_MAX*ADC_Meas_Time);
        }
    }
    DriverPins = Full_Step[0];
    return 0;
}
//////////////////////////////////////////////////////////////////////////////////////
bool MotorMove ()
{
    Dir = !Dir;
    bool Stall = 0;
    Step_Num = 2000;
    
    if(Dir)
    {
        Stall = MotorMoveForward();
    }
    else
    {
        Stall = MotorMoveReverse();
    }
    if (Stall)
    {
        wait(2);
        return 1;
    }
    return 0;
}
/////////////////////////////////////////////////////////////////////////////
bool MotorInit()
{
    bool Stall = 0;
    Step_Num = 10000;
    Dir = 0;
    Stall = MotorMoveReverse();
    if(Stall)
    {
        Dir = !Dir;
        Stall = MotorMoveForward();
        if (Stall)
        {
            return 1;
        }
    }
    return 0;
}
////////////////////////////////////////////////////////////////////////////
int main ()
{
    while(1)
    {
        bool Stall = MotorMove ();
        if(Stall)
        {
            bool Stall = MotorInit();
            if (Stall)
            {
                wait(10);
            }
        }
    }
}