#include "mbed.h"
#include "USBSerial.h"
#if defined(USE_HIDRAW)
#include "BridgeHIDSerial.h"
#else
#include "BridgeCDCSerial.h"
#endif
#include "CommunicationHandler.h"


// Hardware serial port over DAPLink
Serial daplink(P2_1, P2_0);

/* USB Serial Port */
#if defined(USE_HIDRAW)
BridgeHIDSerial *microUSB = new BridgeHIDSerial();
#else
BridgeCDCSerial *microUSB = new BridgeCDCSerial();
#endif

DigitalOut rLED(LED1);
DigitalOut gLED(LED2);
DigitalOut bLED(LED3);

// main() runs in its own thread in the OS
// (note the calls to Thread::wait below for delays)
int main()
{
    CommunicationHandler ch(microUSB);

    while (true) {
        if (!microUSB->configured()) {
            gLED = !gLED;
            rLED = gLED;
            bLED = LED_OFF;
            Thread::wait(500);
        } else if (ch.led_state == CommunicationHandler::LED_STATUS_BUSY) {
            gLED = LED_OFF;
            bLED = !bLED;
            rLED = LED_OFF;
            ch.ledStatusShown();
            Thread::wait(250);
        } else {
            rLED = LED_OFF;
            gLED = !gLED;
            bLED = LED_OFF;
            Thread::wait(500);
        }
    }
    
}

