//
// Bit shifts for CC1200 registers
//

#ifndef LIGHTSPEEDRANGEFINDER_CC1200BITS_H
#define LIGHTSPEEDRANGEFINDER_CC1200BITS_H

#define PKT_CFG2_BYTE_SWAP_EN 6
#define PKT_CFG2_FG_MODE_EN 5
#define PKT_CFG2_CCA_MODE 2
#define PKT_CFG2_PKT_FORMAT 0

#define MDMCFG2_ASK_SHAPE 7
#define MDMCFG2_SYMBOL_MAP_CFG 4
#define MDMCFG2_UPSAMPLER_P 1
#define MDMCFG2_CFM_DATA_EN 0

#define MDMCFG1_CARRIER_SENSE_GATE 7
#define MDMCFG1_FIFO_EN 6
#define MDMCFG1_MANCHESTER_EN 5
#define MDMCFG1_INVERT_DATA_EN 4
#define MDMCFG1_COLLISION_DETECT_EN 3
#define MDMCFG1_DVGA_GAIN 1
#define MDMCFG1_SINGLE_ADC_EN 7

#define MDMCFG0_TRANSPARENT_MODE_EN 6
#define MDMCFG0_TRANSPARENT_INTFACT 4
#define MDMCFG0_DATA_FILTER_EN 3
#define MDMCFG0_VITERBI_EN 2

#define MODCFG_DEV_E_MODEM_MODE 6
#define MODCFG_DEV_E_MOD_FORMAT 3
#define MODCFG_DEV_E_DEV_E 0

#define SYMBOL_RATE2_SRATE_E 4
#define SYMBOL_RATE2_SRATE_M_19_16 0

#define PA_CFG1_PA_RAMP_SHAPE_EN 6
#define PA_CFG1_PA_POWER_RAMP 0

#define PA_CFG0_FIRST_IPL 5
#define PA_CFG0_SECOND_IPL 2
#define PA_CFG0_RAMP_SHAPE 0

#define CHAN_BW_ADC_CIC_DECFACT 6
#define CHAN_BW_BB_CIC_DECFACT 0

#define DCFILT_CFG_DCFILT_FREEZE_COEFF 6
#define DCFILT_CFG_DCFILT_BW_SETTLE 3
#define DCFILT_CFG_DCFILT_BW 0

#define PKT_CFG1_FEC_EN 7
#define PKT_CFG1_WHITE_DATA 6
#define PKT_CFG1_PN9_SWAP_EN 5
#define PKT_CFG1_ADDR_CHECK_CFG 3
#define PKT_CFG1_CRC_CFG 1
#define PKT_CFG1_APPEND_STATUS 0

#define PKT_CFG0_LENGTH_CONFIG 5
#define PKT_CFG0_PKT_BIT_LEN 2
#define PKT_CFG0_UART_MODE_EN 1
#define PKT_CFG0_UART_SWAP_EN 0

#define RFEND_CFG1_RXOFF_MODE 4
#define RFEND_CFG1_RX_TIME 1
#define RFEND_CFG1_RX_TIME_QUAL 0

#define RFEND_CFG0_CAL_END_WAKE_UP_EN 6
#define RFEND_CFG0_TXOFF_MODE 4
#define RFEND_CFG0_TERM_ON_BAD_PACKET_EN 3
#define RFEND_CFG0_ANT_DIV_RX_TERM_CFG 0

#define FS_CFG_FS_LOCK_EN 4
#define FS_CFG_FSD_BANDSELECT 0

#define FSCAL_CTRL_LOCK 0

#define IF_MIX_CFG_CMIX_CFG 2

// bits are the same for all GPIO registers
#define GPIO_ATRAN 7
#define GPIO_INV 6
#define GPIO_CFG 0

#define IQIC_IQIC_EN 7
#define IQIC_IQIC_UPDATE_COEFF_EN 6
#define IQIC_BLEN_SETTLE 4
#define IQIC_BLEN 2
#define IQIC_IMGCH_LEVEL_THR 0

#define SYNC_CFG0_AUTO_CLEAR 5
#define SYNC_CFG0_RX_CONFIG_LIMITATION 4
#define SYNC_CFG0_PQT_GATING_EN 3
#define SYNC_CFG0_EXT_SYNC_DETECT 2
#define SYNC_CFG0_STRICT_SYNC_CHECK 0

#define SYNC_CFG1_SYNC_MODE 5
#define SYNC_CFG1_SYNC_THR 0

#define SETTLING_CFG_FS_AUTOCAL 3
#define SETTLING_CFG_LOCK_TIME 1
#define SETTLING_CFG_FSREG_TIME 0

#define PREAMBLE_CFG1_NUM_PREAMBLE 2
#define PREAMBLE_CFG1_PREAMBLE_WORD 0

#define PREAMBLE_CFG0_PQT_EN 7
#define PREAMBLE_CFG0_PQT_VALID_TIMEOUT 4
#define PREAMBLE_CFG0_PQT 0

#define AGC_CFG3_AGC_SYNC_BEHAVIOUR 5
#define AGC_CFG3_AGC_MIN_GAIN 0

#define AGC_CFG2_START_PREVIOUS_GAIN_EN 7
#define AGC_CFG2_FE_PERFORMANCE_MODE 5
#define AGC_CFG2_AGC_MAX_GAIN 0

#define AGC_CFG1_RSSI_STEP_THR 6
#define AGC_CFG1_AGC_WIN_SIZE 3
#define AGC_CFG1_AGC_SETTLE_WAIT 0

#define AGC_CFG0_AGC_HYST_LEVEL 6
#define AGC_CFG0_AGC_SLEWRATE_LIMIT 4
#define AGC_CFG0_RSSI_VALID_CNT 2
#define AGC_CFG0_AGC_ASK_DECAY 0

#define ASK_CFG_AGC_ASK_BW 6
#define ASK_CFG_ASK_DEPTH 0

#define RSSI0_RSSI_3_0 3
#define RSSI0_CARRIER_SENSE 2
#define RSSI0_CARRIER_SENSE_VALID 1
#define RSSI0_RSSI_VALID 0

#define AGC_CFG1_RSSI_STEP_THR 6
#define AGC_CFG1_AGC_WIN_SIZE 3
#define AGC_CFG1_AGC_SETTLE_WAIT 0

#endif //LIGHTSPEEDRANGEFINDER_CC1200BITS_H
