/*
    USC RPL HAMSTER v2.3 BQ34Z100 Test Suite
    Contributors: Arpad Kovesdy
*/

#pragma once

#include "BQ34Z100.h"
#include "mbed.h"

BQ34Z100 soc(I2C_SDA, I2C_SCL, 10000);

class BQ34Utils {
public:
   void outputStatus();
   void sensorReset();
   void displayData();
   void testICConnection();
   void startCal();
   void stopCal();
   void startIt();
   void writeSettings();
   void calibrateVoltage();
   void calibrateCurrent();
   void resetVoltageCalibration();
   void testFloatConversion();
   void readVoltageCurrent();

private:
	void outputFlashInt(uint8_t* flash, int index, int len);
};
