/* 
	USC RPL HAMSTER v2.3
	Contributors: Lauren Potterat 
*/

#pragma once

#include <mbed.h>

#include "BNO080.h"
#include "BNO080Async.h"
#include "SerialStream.h"

BufferedSerial serial(USBTX, USBRX, 115200);
SerialStream<BufferedSerial> pc(serial);

// These pin assignments are specific to my dev setup -- you'll need to change them
BNO080I2C imu(&pc, PF_0, PF_1, D13, D12, 0x4a, 400000);
//BNO080SPI imu(&pc, D12, D13, D11, PB_4, PB_5, PB_3, PA_4, 3000000);
//BNO080Async imu(&pc, D12, D13, D11, PB_4, PB_5, PB_3, PA_4, 3000000);

class BNOTestSuite{
public:

	void test_printInfo();

	void test_readRotationVector();

	void test_readRotationAcceleration();

	void test_tapDetector();

	void test_gameRotationVector();

	void test_tare();

	void test_magCalibration();

	void test_accelCalibration();

	void test_stabilityClassifier();

	void test_metadata();

	void test_orientation();
	
	void test_permanentOrientation();

	void test_disable();

};
