//
// Created by jamie on 11/12/2020.
//

#include "AccurateWaiter.h"
#include "SerialStream.h"
#include <cinttypes>
#include <random>

namespace chrono = std::chrono;

BufferedSerial serial(USBTX, USBRX, 115200);
SerialStream<BufferedSerial> pc(serial);

std::mt19937 randomGen;
std::uniform_int_distribution<uint64_t> distrib(0, 1e6);

// Thread to perform a precise wait and print the results
void testWaiting()
{
	AccurateWaiter waiter;

	while(true)
	{
		// choose a random wait time
		chrono::microseconds randomWaitTime(distrib(randomGen));

		auto startTime = waiter.clock().now();
		waiter.wait_for(randomWaitTime);
		auto endTime = waiter.clock().now();

		uint64_t actualWaitTime = chrono::duration_cast<chrono::microseconds>(endTime - startTime).count();
		pc.printf("Expected time: %" PRIu64 " us, actual: %" PRIu64 " us, offset = %" PRIi64 "us\n", randomWaitTime.count(), actualWaitTime,
			static_cast<int64_t>(actualWaitTime) - static_cast<int64_t>(randomWaitTime.count()));
	}
}

// infinite loop which is run at normal priority
void infiniteLoop()
{
	int workload;
	while(true)
	{
		workload++;
	}
}

int main()
{
	// print info
	pc.printf("---------------------------------------------\n");
	pc.printf("        Starting Accurate Waiter Test\n");
	pc.printf("---------------------------------------------\n");

	pc.printf("us Ticker Resolution: %.02f us\n", 1e6f/us_ticker_get_info()->frequency);

	// start timing thread
	Thread timingThread(osPriorityHigh);
	timingThread.start(callback(testWaiting));
    
    while(true) {}

	infiniteLoop();

	return 0;
}