/* Aaron Birenboim 26jul15   http://boim.com

Feel free to use as you wish, but please include above credits for the original work

Command interpreter for serial port
*/

class CommandReader
{
public:
  int _nDig,_val;
  BOOL _neg;
  char _code;

  static BOOL hasValue(const char c)
  {
      if ( (c == 'L') || (c == 'R') )
          return(true);
      return(false);    
  }

  void begin(const char c=0)
  {
    _nDig=_val=0;
    _code= hasValue(c) ? c : 0;
    _neg = false;
  }
        
  BOOL get(char &cmdCode, int &cmdVal)
  {
    int i = cSerial.cread();
    if (i < 0) return(false);  // no command yet
    char c = i;
//static int nc=0;DiagSerial.printf("%d got %d(%c)\r\n",nc++,i,i);
//Serial.print('[');Serial.print(i);Serial.print(',');Serial.print(c);Serial.println(']');
    switch(c)
      {
      case '~' :
        CmdSerial.puts("Command Stream RESET!\r\n");
        begin();
        return(false);

      case '0':
      case '1':
      case '2':
      case '3':
      case '4':
      case '5':
      case '6':
      case '7':
      case '8':
      case '9':
        _val = _val*10 + (i-((int)('0')));
        _nDig++;
        //Serial.print(nDig);Serial.print(")");Serial.println(val);
        return(false);
      case '-':
        if ((_nDig == 0) && ((int)_code>0))
          {
            //Serial.println(F("negative command value follows:"));
            _neg = true; // value is negative
          }
        else
          {
            DiagSerial.puts("Not expecting a value.  '-' char ignored.\r\n");
            begin();  // clear bad entry
          }
        return(false);
      // commands without values
      case '!':
      case '?':
      case '^':
      case 'a':  // command to set Autonomous in manual mode
      case 'A':
        cmdCode = c;  // return prev command code (if any)
        cmdVal = 0;
        return(true);
/*
      // codes with values follow : 
      //         might want to leave some of these in here to keep car app from 
      //         throwing error messages, which could saturate the serial connection
      case 'p':
      case 't':
      case 'm':
      case 'C':
      case 'c':
      case 'S':
      case 'T':
      case 'G':
      case 'g':
      case 'r':
      case 'd':
        begin();  // clear old command, if any
        code = c; // remember command for wich the following value applies
        return(false);  // wait for value
*/

      // some android version/settings, there is no seperator.
      // be robust to this
      case 'L':
      case 'R':

        // seperator
      case ' ':
      case '\t':
      case '\r':
      case '\n':
      case 0:
      case ',':
      case ';':
        if ( _code > (char)0 )
          { // command was in progress, close it out
            cmdCode = _code;
            cmdVal = _neg ? -_val : _val;
            begin(c);  // clear for next command
            return(true);  // had a complete command
          }
      default: // treat any other character as a seperator
        begin(c);  // clear any partial command
        return(false);  // prev command not complete
      }
  }

};
