// Aaron Birenboim, 26jul15

// Add some common Serial methods used in Arduino sketches
//
// Serial inherits from stream, for which I have no docuemntation.
// examples seem to indicate that stream has (at least) printf
//
//  I had trouble doing this with proper inheritance.
//  I gave up and just kept a refrence pointer

//#include "Serial.h"

#define EOLN "\r\n"

// singleton serial command byte buffer
#define CMDBUFLEN 64
int cbuf[CMDBUFLEN];
static int bufIn=0;
static int bufOut=0;
void gotChar() {
    int c = CmdSerial.getc();
    cbuf[bufIn % CMDBUFLEN]=c;
    bufIn++;
    // prevent byte count overflow
    //   WARNING:  if there is a race and this thread resets counts...
    //              counts could look funny for a bit, but since bufOut
    //              decrements before bufIn, one hopes that the glitch will not be problematic.
    //       indication of char in the buffer remains correce, and one hopes that by the next
    //       time they check, both counts are accurate.
    if (bufIn > 401*CMDBUFLEN) {
        bufOut -= 400*CMDBUFLEN;
        bufIn  -= 400*CMDBUFLEN;
    }    
}



class ASerial
{
  public:
    Serial *_serial;
    ASerial(Serial &s) : _serial(&s)
    {
        //_serial->attach(&gotChar);
    }
    
    void print(const char *s) { _serial->puts(s);      }
    void print(const int i  ) { _serial->printf("%d",i); }
    void print(const float f) { _serial->printf("%.3f",f); }
    
    void println(const char *s) { print(s); _serial->puts(EOLN); }
    void println(const float f) { print(f); _serial->puts(EOLN); }
    
    void baud(const int i) { _serial->baud(i); }

    int cread()
    {
/*  didn't work.  not sure why.  something about this not being the pc serial?
      int n = _serial->readable();
      if (n)
      {
CmdSerial.printf(" %d readable\t",n);
         char c = _serial->getc();
CmdSerial.printf(" got '%c'(%d)\r\n",c,c);
         return((int)c);   
      }
      return(-1);
*/
        
        if(bufOut < bufIn) {
            int c = cbuf[bufOut % CMDBUFLEN];
            bufOut++;
            //DiagSerial.printf("\r\n\t%d got %d(%c)\r\n",bufOut-1,c,c);
            
            
            int n = bufIn-bufOut;
            if ((n > CMDBUFLEN-3) && (n < 800*CMDBUFLEN)) {
                DiagSerial.printf("\t\r\tCommand Buffer Overflow RESET!\r\n");
                bufIn=bufOut=0;   
            }
            return(c);
        } else { return(-1); }
    }
};
