/**
@file Accel.h
@brief Header file containing functions prototypes, defines and global variables.
@brief Revision 1.0.
@author Mario Quartey Papafio
@date   May 2015
*/

#ifndef ACCEL_H
#define ACCEL_H

#define PI 3.141592

#include "mbed.h"
#include "N5110.h"
#include "MMA8452.h"
#include "PowerControl/PowerControl.h"
#include "PowerControl/EthernetPowerControl.h"


/**
@namespace buffer
@namespace buffer1
@namespace buffer2
@namespace buffer3
@namespace myled
@namespace buzzer
@namespace N5110 lcd
@brief GPIO output for status LED,BUZZER N5110 lcd
*/

//char buffer[14]; 
        // each character is 6 pixels wide, screen is 84 pixels (84/6 = 14)
        // so can display a string of a maximum 14 characters in length
        // or create formatted strings - ensure they aren't more than 14 characters long

/** Initialise LCD and MMA8542 sensor(accelerometer)
    *
    *   Powers up the display and turns on backlight (50% brightness default).
    *   Sets the display up in horizontal addressing mode and with normal video mode.
    *   Powers up MMA8542 sensor
    *   Default values100 Hz update rate, ±4g scale
    */
void turnon();

/** Gets readings and prints to LCD.
    *
    *   Gets the x,y,z data
    *   Calculates Magnitude
    *   Displays Magnitude and x,y,z data
    */
void readings();

/**
@code

/// Buffers for values to be read or calculated
char buffer[14]; // each character is 6 pixels wide, screen is 84 pixels (84/6 = 14)
char buffer1[14]; // each character is 6 pixels wide, screen is 84 pixels (84/6 = 14)
char buffer2[14]; // each character is 6 pixels wide, screen is 84 pixels (84/6 = 14)
char buffer3[14]; // each character is 6 pixels wide, screen is 84 pixels (84/6 = 14)

/// Gets Readings and Displays them
void readings();

PwmOut myled(p22);
PwmOut buzzer(p21);
//    VCC,SCE,RST,D/C,MOSI,SCLK,LED    order of mbed pins should match
N5110 lcd(p7,p8,p9,p10,p11,p13,p26);

@brief AnalogIn input for number of readings per second
@brief serial input for accelerometer readings

MMA8452 mma8452(p28,p27);  // SDA, SCL
Serial serial(USBTX,USBRX);
AnalogIn pot(p20);

Timeout timer; // create ticker object

/// sets flag to 0
int timerFlag = 0; // flag for timer

///Interrupt Service Routine
void timerExpired() {
    timerFlag = 1;
    
    adds float value x
@param x - float to use for pot, to set number of readings per second
@returns the value of x

    /// sets the scale for x to be able to reach 1-45 readings per second
    float x=-(1-pot.read())*44/45+1;
    timer.detach();
    timer.attach(&timerExpired,x);
    
}
///Turns on LCD AND Accelerometer.
void turnon () { 
     lcd.init();
     lcd.printString("Mario Quartey", 0,0);
     lcd.printString("Accelerometer", 0,1);
     lcd.printString("Elec 2645", 0,2);
     lcd.printString("Dr C Evans!", 0,3);
     lcd.refresh();
     wait(2);
     lcd.clear();
     mma8452.init();  // 100 Hz update rate, ±4g scale
     }
/// Gets readings and Prints to LCD
void readings () {
     Acceleration acceleration; 
     lcd.printString("X Y Z Values", 0,0);
        acceleration = mma8452.readValues();   // read current values and print over serial port
         int xx = sprintf(buffer, "x = %.2f", acceleration.x); // figure eout the length of chars
         int yy =  sprintf(buffer1, "y = %.2f", acceleration.y);
         int zz = sprintf(buffer2, "z = %.2f", acceleration.z);
         
         
         ///calculates the square root,multiplication and addition of the 3 arguments and return
         Multiplies and square roots and adds three float variables
         * @param acceleration.x
         * @param acceleration.y
         * @param acceleration.z
         * @returns the multipplication, addition and square root of (acceleration.x)^2 and (acceleration.y)^2 and (acceleration.z)^2
         //
         
          float mag = sqrt((acceleration.x*acceleration.x + acceleration.y*acceleration.y + acceleration.z*acceleration.z));
          int ff = sprintf(buffer3, "Mag = %.2f", mag);
        wait(0.1);   // short delay until next reading
        if (xx <= 14){  // if the length is smaller than 14 chars. it prints
            lcd.printString(buffer, 10, 1);
        if (yy <= 14){  // if the length is smaller than 14 chars. it prints
            lcd.printString(buffer1, 10, 2);
        if (zz <= 14){  // if the length is smaller than 14 chars. it prints
            lcd.printString(buffer2, 10, 3);
        if (mag <= 14){  // if the length is smaller than 14 chars. it prints
            lcd.printString(buffer3, 10, 4);   
        
    /// Compares Values for magnitude and Triggers Buzzer
            if (mag > 1.5)
            for(float p = 0.0f; p < 1.0f; p += 0.1f) {
            buzzer = p;
            wait (0.3);
            buzzer = 0;
        }}}}}}  
        

int main() {
   turnon();
    
    timer.attach(&timerExpired,1);

PHY_PowerDown(); //Powers Down ethernet

/// Flash LED in Infinite loop, while readings are being taken.
    while (1) {
       
        for(float p = 0.0f; p < 1.0f; p += 0.1f) {
            myled = p;
             }
         if (timerFlag) {
            readings ();
            
            timerFlag = 0;
            }
       lcd.refresh();
        }
            
     }
*/

#endif