/**
@file Accel.cpp
@brief Program Implementation
*/

#include "Accel.h"
#include "mbed.h"
#include "N5110.h"
#include "MMA8452.h"
#include "PowerControl/PowerControl.h"
#include "PowerControl/EthernetPowerControl.h"

/// Buffers for values to be read or calculated
char buffer[14]; // each character is 6 pixels wide, screen is 84 pixels (84/6 = 14)
char buffer1[14]; // each character is 6 pixels wide, screen is 84 pixels (84/6 = 14)
char buffer2[14]; // each character is 6 pixels wide, screen is 84 pixels (84/6 = 14)
char buffer3[14]; // each character is 6 pixels wide, screen is 84 pixels (84/6 = 14)

/// Gets Readings and Displays them
void readings();

PwmOut myled(p22);
PwmOut buzzer(p21);
//    VCC,SCE,RST,D/C,MOSI,SCLK,LED    order of mbed pins should match
N5110 lcd(p7,p8,p9,p10,p11,p13,p26);
MMA8452 mma8452(p28,p27);  // SDA, SCL
Serial serial(USBTX,USBRX);
AnalogIn pot(p20);

Timeout timer; // create ticker object

/// sets flag to 0
int timerFlag = 0; // flag for timer

///Interrupt Service Routine
void timerExpired() {
    timerFlag = 1;
    
    /// sets the scale for x to be able to reach 1-45 readings per second
    float x=-(1-pot.read())*44/45+1;
    timer.detach();
    timer.attach(&timerExpired,x);
    
}
///Turns on LCD AND Accelerometer.
void turnon () { 
     lcd.init();
     lcd.printString("Mario Quartey", 0,0);
     lcd.printString("Accelerometer", 0,1);
     lcd.printString("Elec 2645", 0,2);
     lcd.printString("Dr C Evans!", 0,3);
     lcd.refresh();
     wait(2);
     lcd.clear();
     mma8452.init();  // 100 Hz update rate, ±4g scale
     }
/// Gets readings and Prints to LCD
void readings () {
     Acceleration acceleration; 
     lcd.printString("X Y Z Values", 0,0);
        acceleration = mma8452.readValues();   // read current values and print over serial port
         int xx = sprintf(buffer, "x = %.2f", acceleration.x); // figure eout the length of chars
         int yy =  sprintf(buffer1, "y = %.2f", acceleration.y);
         int zz = sprintf(buffer2, "z = %.2f", acceleration.z);
         ///calculates the square root,multiplication and addition of the 3 arguments and return
          float mag = sqrt((acceleration.x*acceleration.x + acceleration.y*acceleration.y + acceleration.z*acceleration.z));
          int ff = sprintf(buffer3, "Mag = %.2f", mag);
        wait(0.1);   // short delay until next reading
        if (xx <= 14){  // if the length is smaller than 14 chars. it prints
            lcd.printString(buffer, 10, 1);
        if (yy <= 14){  // if the length is smaller than 14 chars. it prints
            lcd.printString(buffer1, 10, 2);
        if (zz <= 14){  // if the length is smaller than 14 chars. it prints
            lcd.printString(buffer2, 10, 3);
        if (mag <= 14){  // if the length is smaller than 14 chars. it prints
            lcd.printString(buffer3, 10, 4);   
        
    /// Compares Values for magnitude and Triggers Buzzer
            if (mag > 1.5)
            for(float p = 0.0f; p < 1.0f; p += 0.1f) {
            buzzer = p;
            wait (0.3);
            buzzer = 0;
        }}}}}}  
        

int main() {
   turnon();
    
    timer.attach(&timerExpired,1);

PHY_PowerDown(); //Powers Down ethernet

/// Flash LED in Infinite loop, while readings are being taken.
    while (1) {
       
        for(float p = 0.0f; p < 1.0f; p += 0.1f) {
            myled = p;
             }
         if (timerFlag) {
            readings ();
            
            timerFlag = 0;
            }
       lcd.refresh();
        }
            
     }
