#include "mbed.h"
#include "C027_api.h"


/* This example is establishing a transparent link between 
   the mbed serial port and the serial communication interface 
   of the Modem(MDM). 
   
   For a more advanced driver for the GPS or Modem(MDM) please 
   look at the follwing library and example:
   C027_Support Library 
     http://mbed.org/teams/ublox/code/C027_Support/
   C027_Support Example
     http://mbed.org/teams/ublox/code/C027_SupportTest/
*/
int main() 
{
    // setting the power on pin low while powering the device will turn it on
    DigitalOut pin(MDMPWRON, 0);
    wait_ms(10);
    c027_mdm_powerOn(false);
    
    // open the mdm serial port
    Serial mdm(MDMTXD,MDMRXD);
    mdm.baud(MDMBAUD);
    mdm.set_flow_control(SerialBase::RTSCTS, MDMRTS,MDMCTS);
    
    // open the PC serial port and (use the same baudrate)
    Serial pc(P4_28, P4_29);
    pc.baud(MDMBAUD);
    while (1)
    {
        // transfer data from pc to modem
        if (pc.readable() && mdm.writeable())
        {
            mdm.putc(pc.getc());
        }
        // transfer data from modem to pc
        if (mdm.readable() && pc.writeable())
        {
            pc.putc(mdm.getc());
        }
    }
}
