#include "mbed.h"
#include "MDM.h"
#include "C027_api.h"
//------------------------------------------------------------------------------------
// You need to configure these cellular modem / SIM parameters.
//! Set your secret SIM pin here (e.g. "1234"). Check your SIM manual.
#define SIMPIN      NULL
/*! The APN of your network operator SIM, sometimes it is "internet" check your 
    contract with the network operator. You can also try to look-up your settings in 
    google: https://www.google.co.uk/search?q=APN+list */
#define APN         NULL
//! Set the user name for your APN, or NULL if not needed
#define USERNAME    NULL
//! Set the password for your APN, or NULL if not needed
#define PASSWORD    NULL 
//------------------------------------------------------------------------------------
Serial pc(USBTX, USBRX);
Serial bbb(P4_28, P4_29);
int main(void)
{
    // Create the modem object
    MDMSerial mdm;
    // initialize the modem 
    MDMParser::DevStatus devStatus = {};
    MDMParser::NetStatus netStatus = {};
    bool mdmOk = false;
    while (!mdmOk)
    {
        mdmOk=mdm.init(SIMPIN, &devStatus);
    }
    do
    {
        mdmOk = mdm.registerNet(&netStatus);
    }
    while (!mdmOk);    
    mdm.dumpNetStatus(&netStatus);
    mdm.dumpDevStatus(&devStatus);
    printf("SMS and GPS Loop\r\n");
    char* num =  "+447923598328";
    char* reply;
    int n;
    printf("Please input the content.\n");
    bbb.putc('o');
    while (bbb.getc() != 'S')
    {
        continue;
    }
    send:
    pc.puts("New SMS\n");
    n = 0;
    reply = new char [140];
    reply[0] = '\0';
    char tmpc = bbb.getc();
    while (true)
    {
        if (tmpc == ' ' or tmpc == '\n')
        {
            bbb.puts(reply);
            char tmp = bbb.getc();
            while(tmp != 'T' and tmp != 'F')
            {
                tmp = bbb.getc();
                continue;
            }
            pc.puts(reply);
            pc.putc('\n');
            if (tmp == 'T')
            {
                 mdm.smsSend(num, reply);
                 pc.puts(reply);
                 pc.putc('\n');
                 if ( tmpc == '\n')
                 {
                    delete [] reply ;
                    bbb.putc('o');
                    goto finish;
                 }
            }
            else
            {
                pc.puts("Discard\n");
            }
            delete reply;
            bbb.putc('o');
            goto send;
        }
        reply[n] = tmpc;
        reply[n+1] = '\0';
        ++n;
        tmpc = bbb.getc();    
    }
    finish: 
    pc.puts(reply);
    pc.putc('\n');
    pc.puts("SMS sent\n");
    mdm.powerOff();
    return 0;
}
