// Scalextric Timer for Ada Lovelace Day
//
// Uses Nucleo board F072 with LCD Keypad shield
// Connect D3 to Trig & D2 to Echo
// Connect VCC to 5V (pin CN7 18)
// Connect GND to 0V (pin CN7 19)

#include "mbed.h"
#include "hcsr04.h"     // Ultrasonic sensor
#include "TextLCD.h"    // LCD1602

// serial PC for debug
//Serial pc(SERIAL_TX, SERIAL_RX);
// Ultrasonic sensor
HCSR04  usensor(D3,D2);  // Trig, Echo  - locks sometimes

// LCD Shield
TextLCD lcd(D8, D9, D4, D5, D6, D7);   // used to drive display
//AnalogIn keys(A0);                     // used to sample buttons

Timer lap_timer;

// Subroutine to display text on LCD - called from below
// call as follows:
// textLCD(text, line)
// where text = up to 16 characters of text
// line = line 0 or 1 on the LCD; where 0 is the top line and 1 is the bottom line
    
void textLCD(char *text, int line) {

    char tmpBuf[16];    
    for (int i = 0; i < 14; i++) {
        if (i < strlen(text)) {
          tmpBuf[i] = text[i];
        } 
        else 
        {
            tmpBuf[i] = 0x20;
        }
        lcd.locate(i, line);
        lcd.putc(tmpBuf[i]);
    }
}

// Subroutine to display Lap data on LCD - called from below
// call as follows:
// DisplayLap(lap_count, dist, lap_time, Show_Time);

void DisplayLap(int lcl_lap_count, int lcl_dist, float lcl_lap_time, bool Show_Time) {

    char lap_string[16];    
    char lap_string2[16];    
    //textLCD("1               ", 0);  // Clear top line on LCD
    //textLCD("2               ", 1);  // Clear bottom line on LCD
    //lcd.cls();

    int lcl_lap_time_integerPart = (int)lcl_lap_time;
    int lcl_lap_time_decimalPart = ((int)(lcl_lap_time*1000)%1000);

    sprintf(lap_string, "Lap : %d D : %d", (char*)lcl_lap_count, (char*)lcl_dist);      // Format Lap count string   
//    pc.printf("%s \n\r", lap_string);
    textLCD("1               ", 0);  // Clear top line on LCD
    textLCD(lap_string, 0);          // Display distance on LCD
    
    if (Show_Time) {
        sprintf(lap_string2, "Time : %d.%d s, ", (char*)lcl_lap_time_integerPart, (char*)lcl_lap_time_decimalPart);  // Format Lap time string
//        pc.printf("%s \n\r", lap_string);
        textLCD("1               ", 1);  // Clear bottom line on LCD
        textLCD(lap_string2, 1);      // Display Lap Time on LCD
    }
 }
        
///////////////////////////////////////////////////////////////////////////////
// Main Program starts here
///////////////////////////////////////////////////////////////////////////////

int main()
{
 
 //// Try changing these:
    // Variables to tune
    float min_laptime = 1.0; // Minimum laptime - time to wait after seeing car before measuring again in seconds
    int sample_time = 500;   // Sample time - time between sampling values from sensor in milliseconds
    int trigger_distance = 5;  // Trigger distance - distance below which the car registers as detected
//// Careful with anything after this though

    // Variables used within the program - set to their initial values
    int dist = 0;
    float lap_time = 0.0;
    int lap_count = 0;

    
    // Initialise the serial interface and set its data rate
 //   pc.baud(9600);

    // Intro Screen
 //   pc.printf("ARM Sheffield Scalextric Challenge \n"); // Display to Serial Interface
    textLCD("ARM Scalextric ", 0);  // Display on First Line of LCD
    wait_ms(2000);  // Wait 2s
    textLCD("                ", 0);  // Clear top line on LCD

    // Main loop - runs forever
    while(1) {
       // Set up and read ultrasonic sensor after "sample_time"
       usensor.start();
       wait_ms(sample_time);
       dist=usensor.get_dist_cm();  // read sesnsor distance measure 
       //pc.printf("Lap %d Distance %d wait_time %d \n\r", lap_count, dist, wait_time);  // Debug - display distance to Serial Interface
       if (dist < trigger_distance) { // Spotted something closer than trigger_distance from the sensor
         if (lap_count == 0) {   // First Lap - start lap timer
           lap_timer.reset();
           lap_timer.start();
           //pc.printf("Timing... \r");        // Debug to Serial Interface
           textLCD("Timing..........", 1);   // Message to LCD
         } else {                // Completed a lap
           lap_time = lap_timer.read();  // Get time for lap
           lap_timer.reset();
           DisplayLap(lap_count, dist, lap_time, 1);
        }
        lap_count++;               // Increment lap counter by 1
        wait(min_laptime);         // Wait for a time before starting to monitor sensor for next lap
      }     // end of something spotted
      else  // nothing spotted - output debug
      {   
        DisplayLap(lap_count, dist, lap_time, 0);
      }
    }     // end of main while loop
    
     
}  // end of main program

