#include "mbed.h"
#include "DHT.h"
#include "TextLCD.h"    // LCD1602
 
DHT sensor(PA_11, DHT11);
Serial pc(SERIAL_TX, SERIAL_RX);
 
 // LCD pins
TextLCD lcd(D8, D9, D4, D5, D6, D7);
AnalogIn keys(A0);

// diplay text on LCD
void textLCD(char *text, int line) {
    char tmpBuf[16];
    for (int i = 0; i < 16; i++) tmpBuf[i] = 0x20;
    for (int i = 0; i < strlen(text); i++) {
        if (i < 16) tmpBuf[i] = text[i];
    }
    
    lcd.locate(0, line);
    lcd.printf(tmpBuf);
}


int main()
{
    int error = 0;
    float h = 0.0f, c = 0.0f, f = 0.0f, k = 0.0f, dp = 0.0f, dpf = 0.0f;
    pc.baud(9600);
    lcd.cls();
    char tmpString[16];
    char tmpString2[16];
    int iKey = 0;
    int oldiKey = 0;
    int temp_format = 0;
    int humid_format = 0;
    
    while(1) {
        iKey = keys.read_u16();
        if (iKey != oldiKey) {   // button press            
            oldiKey = iKey;                 
            if ((iKey >= 0) &&(iKey < 0x1800)) { // right
              temp_format++;
              if (temp_format == 3) temp_format = 0;
            } else if ((iKey >= 0x8000) && (iKey < 0xc000)) { // left
              humid_format++;
              if (humid_format == 3) humid_format = 0;
            }
            //} else if ((iKey >=  0x1800) && (iKey < 0x5000)) { // up
            //} else if ((iKey >= 0x5000) && (iKey < 0x8000)) { // down
            //} else if ((iKey >= 0xc000) && (iKey < 0xfa00)) { // sel
            //} else { // nowt
            //}
       } 
        
        wait(2.0f);
        error = sensor.readData();
        if (0 == error) {
            c   = sensor.ReadTemperature(CELCIUS);
            f   = sensor.ReadTemperature(FARENHEIT);
            k   = sensor.ReadTemperature(KELVIN);
            h   = sensor.ReadHumidity();
            dp  = sensor.CalcdewPoint(c, h);
            dpf = sensor.CalcdewPointFast(c, h);
            pc.printf("Temperature in Kelvin: %4.2f, Celcius: %4.2f, Farenheit %4.2f\n", k, c, f);
            pc.printf("Humidity is %4.2f, Dewpoint: %4.2f, Dewpoint fast: %4.2f\n", h, dp, dpf);
            pc.printf("Tempformat: %d HumidFormat: %d\n", temp_format, humid_format);
            switch(temp_format) {
                case 0 : sprintf(tmpString, " Temp: %4.2fC", c); break;
                case 1 : sprintf(tmpString, " Temp: %4.2fF", f); break;
                case 2 : sprintf(tmpString, " Temp: %4.2fK", k); break;
            }     
            textLCD(tmpString, 0);
            switch(humid_format) {
                case 0 : sprintf(tmpString2, "Humid: %4.2f", h); break;
                case 1 : sprintf(tmpString2, "Dewpoint: %4.2f", dp); break;
                case 2 : sprintf(tmpString2, "DewpFast: %4.2f", dpf); break;
            }                   
            textLCD(tmpString2, 1);            
        } else {
            pc.printf("Error: %d\n", error);
            textLCD("Error", 0);
        }
    }
}