#include "mbed.h"

#define PI 3.142
#define AMP 0.8

#define SIGNAL_OUTPUT_FREQ 25//usec
// coz twice zone of human audibility
AnalogOut signal(p18);
AnalogIn adin(p17);

Ticker t_wave;

float freq;

float wave_value;
void sawtoothWave(){
    wave_value+=freq*SIGNAL_OUTPUT_FREQ/1000000;
    if(wave_value > 1.0)
        wave_value = 0.0;
    float output = AMP*wave_value;
    signal = output;
}

float theata;
void sinWave(){
    theata += 2*PI*SIGNAL_OUTPUT_FREQ*freq/1000000;
    if(theata > 2*PI)
        theata = 0.0; 
    float output = AMP*( sin(theata)+0.5 );
    signal = output;
}

int main() {
    wave_value = 0.0;
    freq = 1000;
    t_wave.attach_us(&sinWave , SIGNAL_OUTPUT_FREQ);
    while(1){
        freq = 5000*adin.read();
    } 
}
