/**
 * RPC Remote
 * 
 * 赤外線信号の送信をRPCを介して送信するプログラム
 * (2014年3月2日公開) 
 * Takumi Okamoto 
 * 注意：現在の所、安定した動作をしていません。
 * 朝電源を入れて、夕方頃には動作をしていないことが多々あります。
 */


#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "TransmitterIR.h"
#include "RPCFunction.h"
#include "RPCVariable.h"

TransmitterIR ir_tx(p21);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

LocalFileSystem fs("webfs");


/*
EthernetNetIf   m_Ether(
    IpAddr( 192,168,  0, 7 ), // IP Address
    IpAddr( 255,255,255,  0 ), // Mask
    IpAddr( 192,168,  0,  1 ), // Default Gateway
    IpAddr( 192,168,  0,  1 )  // DNS
);
*/
EthernetNetIf eth;

HTTPServer svr;


/**
 * RPCに登録する関数野プロトタイプ宣言
 * RPCに登録できる関数は
 * void funtion(char * input, char * output)
 * の形
 */
void irSend(char * input, char * output);
void irSignalSend(char * input , char * output);
void turnONLight1(char * input, char * output);
void turnONLight2(char * input, char * output);
void turnONAirConditioner(char* input,char* output);

/**
 * RPCへの関数の登録
 * RPCFunction rpc_TurnONLight1(関数アドレス,"コールする際のテキスト");
 * TODO sscanf等を使用して、汎用的な赤外線信号の送信関数を作る
 */
RPCFunction rpc_TurnONLight1(&turnONLight1,"light1");
RPCFunction rpc_TurnONLight2(&turnONLight2,"light2");
RPCFunction rpc_turnONAirConditioner(&turnONAirConditioner,"aircon");

void turnONLight1(char * input, char * output){
    
    RemoteIR::Format format = RemoteIR::NEC;
    uint8_t buf[] = { 0x82, 0xE8, 0x80, 0x7F };//結局ベタ書きしてます。
    int bitcount = 32;
    for(int i=0; i<3 ;i++){
        if (ir_tx.getState() == TransmitterIR::Idle) {
            bitcount = ir_tx.setData(format, buf, bitcount);
        }
    }
    led4=1;
    wait(0.5);
    led4=0;
    
    printf("light1");
}

void turnONLight2(char * input, char * output){
    RemoteIR::Format format = RemoteIR::NEC;
    uint8_t buf[] = { 0x82, 0xE8, 0x81, 0x7E };//
    int bitcount = 32;
     for(int i=0; i<3 ;i++){
        if (ir_tx.getState() == TransmitterIR::Idle) {
            bitcount = ir_tx.setData(format, buf, bitcount);
        }
    }
    led4=1;
    wait(0.5);
    led4=0;
    
    printf("light2");
}

void turnONAirConditioner(char* input,char* output){
    RemoteIR::Format format = RemoteIR::AEHA;
    uint8_t buf[] = {
         0x23, 0xCB, 0x26, 0x01,
         0x00, 0x20, 0x08,0x0A, 
         0x30, 0x40, 0x00, 0x00, 
         0x00, 0x00, 0x00, 0x00, 
         0x00, 0xB7 };//
    int bitcount = 144;
    for(int i=0; i<3 ;i++){
        if (ir_tx.getState() == TransmitterIR::Idle) {
            bitcount = ir_tx.setData(format, buf, bitcount);
        }
    }
    led4=1;
    wait(0.5);
    led4=0;
    
    printf("aircon");
}

/**
 * メイン関数
 * 
 */
int main()
{
    Base::add_rpc_class<DigitalOut>();
    Base::add_rpc_class<AnalogIn>();
    Base::add_rpc_class<PwmOut>();

    printf("Setting up...\n");

    EthernetErr ethErr = eth.setup();
    if(ethErr) {
        printf("Error %d in setup.\n", ethErr);
        return -1;
    }
    printf("Setup OK\n");
    IpAddr ip = eth.getIp() ;             //IP Address Read
    printf(" [%d.%d.%d.%d]\r\n", ip[0], ip[1], ip[2], ip[3] ) ;

    FSHandler::mount("/webfs", "/files"); //Mount /webfs path on /files web path
    FSHandler::mount("/webfs", "/"); //Mount /webfs path on web root path

    svr.addHandler<RPCHandler>("/rpc");// /rpcをRPCのパスとして設定
    svr.addHandler<FSHandler>("/files");
    svr.addHandler<FSHandler>("/"); //Default handler
    svr.bind(80);//

    printf("Listening...\n");

    led1 = 0;
    while(true) {
        Net::poll();
    }
}

