/**
 * This program is test for p9813 IC 
 **/


#include "mbed.h"

//DigitalOut led(LED1);
BusOut leds(LED1,LED2,LED3,LED4);
AnalogIn analog(p15);


#define H 1
#define L 0

DigitalOut di(p10);//signal
DigitalOut ci(p11);//clock

void sendBit(char bit){
    ci =L;
    di = (bit==0 ? L:H );
    ci=H;//read DI at rising edge
}
char toGrayCode(char byte){
    char shift = byte>>1;
    return shift^byte;
}

void sendByte(char byte){
    char mask =0x80;
    for(  ; mask != 0x00 ; mask>>=1){// 1000 0000
        sendBit(byte & mask);
    }
}

void sendStartFrame(){
    for(int i = 0; i<4 ;i++){
        sendByte(0x00);
    }
}

void sendStopFrame(){
    sendStartFrame();
}


void sendRGB(char rb,char gb ,char bb){
    /*
    printf("******\n");
    printf("r is %X \n",rb);
    printf("g is %X \n",gb );
    printf("b is %X \n",bb );
    printf("******\n\n");
    */
    char r = toGrayCode(rb);
    char g = toGrayCode(gb);
    char b = toGrayCode(bb);
    
    sendStartFrame();
    sendBit(H);
    sendBit(H);
    // error check
    sendBit( (~b) & 0x80 );//mask by 1000 0000
    sendBit( (~b) & 0x40 );//mask by 0100 0000
    sendBit( (~g) & 0x80 );//mask by 1000 0000
    sendBit( (~g) & 0x40 );//mask by 0100 0000
    sendBit( (~r) & 0x80 );//mask by 1000 0000
    sendBit( (~r) & 0x40 );//mask by 0100 0000
    //send RGB data
    sendByte(b);
    sendByte(g);
    sendByte(r);
    sendStopFrame();
}

void sendRGB(int rgb){
    char r = (char) ((rgb & 0x00FF0000) >> 16);
    char g = (char) ((rgb & 0x0000FF00) >> 8);
    char b = (char) ( rgb & 0x000000FF);
    //printf("r:%X,g:%X,b:%X \n",r,g,b);
    sendRGB(r,g,b);
}



int main() {
    int rgb =0x000000;
    int color[] ={
        0x00000000,
        0x000000FF,
        0x0000FF00,
        0x0000FFFF,
        0x00FF0000,
        0x00FF00FF,
        0x00FFFF00,
        0x00FFFFFF};
    leds =0x0;
    int index=0;
    while(1) {
        //printf("%d\n",index);
        leds=leds+1;
        sendRGB(color[index]);
        index++;    
        if(index == 8){
            index = 0;
            //printf("******");
        }
        wait(2.0*analog.read());
        /*
        leds=leds+1;
        sendRGB(0xFF,0x00,0x00);
        wait(2.0*analog.read());
        leds=leds+1;
        sendRGB(0x00,0xFF,0x00);
        wait(2.0*analog.read());
        leds=leds+1;
        */
    }
}
