#include "mbed.h"

// class to play a note on Speaker based on PwmOut class
#ifndef _SPEAKER_H
#define _SPEAKER_H

class Speaker
{
public:
    // Constructor
    Speaker(PinName pin) : _pin(pin) {}
    // member function to play a given note
    void PlayNote(float frequency, float duration, float volume) {
        _pin.period(1.0/frequency);
        _pin = volume/2.0;
        wait(duration);
        _pin = 0.0;
    }

private:
    PwmOut _pin;
};

#endif // _SPEAKER_H