#ifndef BIRD_H
#define BIRD_H

// enumerated type that represents the direction that the bird moves
enum directionType {DIRECTION_UP, DIRECTION_DOWN};

// class that represents the bird in the Flappy Bird game
class Bird 
{
public:
    // Constructor
    Bird();
    // Get Functions
    int getX();                 // return the bird's current x position
    int getY();                 // return the bird's current y position
    int getOldY();              // return the bird's previous y position
    int getWidth();             // return the bird's width
    int getHeight();            // return the bird's height
    // Member Functions
    void move(directionType);   // moves the bird in a given direction

private:
    // variables
    int x;                              // the bird's x position
    int y;                              // the bird's y position
    int oldY;                           // the bird's previous y position
    // constants
    static const int width = 16;        // the bird's width
    static const int height = 16;       // the bird's height
    static const int moveDistance = 8;  // the distance that the bird moves
};

#endif // BIRD_H