#include "Speaker.h"

#ifndef SOUNDBUILDER_H
#define SOUNDBUILDER_H

// class that represents a note played by a speaker
class Note
{
public:
    // Constructor
    Note();
    Note(float, float, float);
    // Set Functions
    void setFreq(float);        // set the note's frequency
    void setLength(float);      // set the note's length
    void setVolume(float);      // set the note's volume
    // Get Functions
    float getFreq();            // return the note's frequency
    float getLength();          // return the note's length
    float getVolume();          // return the note's volume
private:
    float freq;                 // the note's frequency
    float length;               // the note's length
    float volume;               // the note's volume
};

class SoundBuilder
{
public:
    // Set Song
    SoundBuilder (float [], float [], float [], int, Speaker *);
    // Set sound, where int is the note number starting from 0
    void setNote(float, float, float, int);
    // Play Song from given start and stop positions
    void playNotes(int, int);
    // Play Song
    void playSong();
    // Clear Songs
    void clearSong();

private:
    Note song[20];      // a song of up to 20 notes
    Speaker *speaker;   // speaker that plays the song
    
};

#endif // SOUNDBUILDER_H