#include "Speaker.h"
#include "soundBuilder.h"

Note::Note(){
    setFreq(0);
    setLength(0);
    setVolume(0);
}

Note::Note(float freq, float dur, float vol){
    setFreq(freq);
    setLength(dur);
    setVolume(vol);
}

void Note::setFreq(float nfreq){
    freq = nfreq;
}

void Note::setLength(float dur){
    length = dur;
}

void Note::setVolume(float vol){
    volume = vol;
}

float Note::getFreq(){
    return freq;
}

float Note::getLength(){
    return length;
}

float Note::getVolume(){
    return volume;
}

SoundBuilder::SoundBuilder(float freq[], float dur[], float vol[], int numNotes, Speaker *mainspeaker){
    // add each note to the song
    for (int i = 0; i < numNotes; i++){
        song[i].setFreq(freq[i]);
        song[i].setLength(dur[i]);
        song[i].setVolume(vol[i]);
    }
    speaker = &(*mainspeaker);
}

void SoundBuilder::setNote(float freq, float dur, float vol, int noteNum){
    // set frequency, length, and volume of the specified note
    song[noteNum].setFreq(freq);
    song[noteNum].setLength(dur);
    song[noteNum].setVolume(vol);
}

void SoundBuilder::playNotes(int start, int stop){
    // play each note in the song successively from given start and stop positions
    for (int i = start; i <= stop; i++)
        speaker->PlayNote(song[i].getFreq(), song[i].getLength(), song[i].getVolume());
}

void SoundBuilder::playSong(){
    // play each note in the song successively from the beginning to the end
    playNotes(0, sizeof(song)/sizeof(*song)-1);
}

void SoundBuilder::clearSong(){
    // clear all note data from the song
    for (int i = 0; i < sizeof(song)/sizeof(*song); i++){
        song[i].setFreq(0);
        song[i].setLength(0);
        song[i].setVolume(0);
    }
}